/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.contrib;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tvm.Device;
import org.apache.tvm.Function;
import org.apache.tvm.Module;
import org.apache.tvm.contrib.GraphModule;

public class GraphExecutor {
    public static GraphModule create(String graphJson, Module libmod, Device dev) {
        Function fcreate = Function.getFunction("tvm.graph_executor.create");
        if (fcreate == null) {
            throw new RuntimeException("Cannot find global function tvm.graph_executor.create.Did you compile tvm_runtime with correct version?");
        }
        Module graphModule = fcreate.pushArg(graphJson).pushArg(libmod).pushArg(dev.deviceType).pushArg(dev.deviceId).invoke().asModule();
        return new GraphModule(graphModule, dev);
    }

    private static Object reflectionGetField(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object reflectionStaticCall(Class<?> clazz, String methodName, Object ... args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getClass();
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, types);
            method.setAccessible(true);
            return method.invoke(null, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

