/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

import java.io.IOException;
import org.apache.tvm.rpc.ConnectProxyServerProcessor;
import org.apache.tvm.rpc.ServerProcessor;
import org.apache.tvm.rpc.StandaloneServerProcessor;

public class Server {
    private final WorkerThread worker;

    public Server(int serverPort) throws IOException {
        this.worker = new WorkerThread(new StandaloneServerProcessor(serverPort));
    }

    public Server(String proxyHost, int proxyPort, String key) {
        this.worker = new WorkerThread(new ConnectProxyServerProcessor(proxyHost, proxyPort, key));
    }

    public void start() {
        this.worker.start();
    }

    public void terminate() {
        this.worker.terminate();
    }

    private static class WorkerThread
    extends Thread {
        private volatile boolean running = true;
        private final ServerProcessor processor;

        public WorkerThread(ServerProcessor processor) {
            this.processor = processor;
        }

        @Override
        public void run() {
            while (this.running) {
                this.processor.run();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void terminate() {
            this.running = false;
            this.processor.terminate();
        }
    }
}

