/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class Utils {
    Utils() {
    }

    public static byte[] recvAll(InputStream in, int numBytes) throws IOException {
        int chunk;
        byte[] res = new byte[numBytes];
        for (int numRead = 0; numRead < numBytes; numRead += chunk) {
            chunk = in.read(res, numRead, Math.min(numBytes - numRead, 1024));
        }
        return res;
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.shutdownInput();
                socket.shutdownOutput();
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ByteBuffer wrapBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb;
    }

    public static byte[] toBytes(int number) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb.putInt(number).array();
    }

    public static byte[] toBytes(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            bytes[i] = (byte)str.charAt(i);
        }
        return bytes;
    }

    public static String decodeToStr(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte bt : bytes) {
            builder.append((char)bt);
        }
        return builder.toString();
    }

    public static String recvString(InputStream in) throws IOException {
        String recvString = null;
        int len = Utils.wrapBytes(Utils.recvAll(in, 4)).getInt();
        recvString = Utils.decodeToStr(Utils.recvAll(in, len));
        return recvString;
    }

    public static void sendString(OutputStream out, String string) throws IOException {
        out.write(Utils.toBytes(string.length()));
        out.write(Utils.toBytes(string));
    }
}

