/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm;

import java.util.HashMap;
import java.util.Map;
import org.apache.tvm.ArgTypeCode;
import org.apache.tvm.Base;
import org.apache.tvm.Function;
import org.apache.tvm.TVMValue;

public class Module
extends TVMValue {
    public final long handle;
    private boolean isReleased = false;
    private static ThreadLocal<Map<String, Function>> apiFuncs = new ThreadLocal<Map<String, Function>>(){

        @Override
        protected Map<String, Function> initialValue() {
            return new HashMap<String, Function>();
        }
    };
    private Function entry = null;
    private final String entryName = "__tvm_main__";

    private static Function getApi(String name) {
        Function func = apiFuncs.get().get(name);
        if (func == null) {
            func = Function.getFunction("runtime." + name);
            apiFuncs.get().put(name, func);
        }
        return func;
    }

    Module(long handle) {
        super(ArgTypeCode.MODULE_HANDLE);
        this.handle = handle;
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @Override
    public Module asModule() {
        return this;
    }

    @Override
    long asHandle() {
        return this.handle;
    }

    @Override
    public void release() {
        if (!this.isReleased) {
            Base.checkCall(Base._LIB.tvmModFree(this.handle));
            this.isReleased = true;
        }
    }

    public Function entryFunc() {
        if (this.entry == null) {
            this.entry = this.getFunction("__tvm_main__");
        }
        return this.entry;
    }

    public Function getFunction(String name, boolean queryImports) {
        Base.RefLong retHandle = new Base.RefLong();
        Base.checkCall(Base._LIB.tvmModGetFunction(this.handle, name, queryImports ? 1 : 0, retHandle));
        if (retHandle.value == 0L) {
            throw new IllegalArgumentException("Module has no function " + name);
        }
        return new Function(retHandle.value, false);
    }

    public Function getFunction(String name) {
        return this.getFunction(name, false);
    }

    public void importModule(Module module) {
        Base.checkCall(Base._LIB.tvmModImport(this.handle, module.handle));
    }

    public String typeKey() {
        return Module.getApi("ModuleGetTypeKey").pushArg(this).invoke().asString();
    }

    public static Module load(String path, String fmt) {
        TVMValue ret = Module.getApi("ModuleLoadFromFile").pushArg(path).pushArg(fmt).invoke();
        assert (ret.typeCode == ArgTypeCode.MODULE_HANDLE);
        return ret.asModule();
    }

    public static Module load(String path) {
        return Module.load(path, "");
    }

    public static boolean enabled(String target) {
        TVMValue ret = Module.getApi("RuntimeEnabled").pushArg(target).invoke();
        return ret.asLong() != 0L;
    }
}

