/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.apache.tvm.Base;
import org.apache.tvm.NDArrayBase;
import org.apache.tvm.TVMContext;
import org.apache.tvm.TVMType;

public class NDArray
extends NDArrayBase {
    private final TVMType dtype;
    private final TVMContext context;

    NDArray(long handle, boolean isView, TVMType dtype, TVMContext ctx) {
        super(handle, isView);
        this.dtype = dtype;
        this.context = ctx;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void copyFrom(double[] sourceArray) {
        this.checkCopySize(sourceArray.length);
        if (this.dtype.typeCode != 2 || this.dtype.bits != 64) {
            throw new IllegalArgumentException("Cannot set double[] for " + this.dtype.toString() + " array");
        }
        byte[] nativeArr = new byte[sourceArray.length * this.dtype.numOfBytes];
        for (int i = 0; i < sourceArray.length; ++i) {
            NDArray.wrapBytes(nativeArr, i * this.dtype.numOfBytes, this.dtype.numOfBytes).putDouble(sourceArray[i]);
        }
        NDArray tmpArr = NDArray.empty(this.shape(), this.dtype);
        Base.checkCall(Base._LIB.tvmArrayCopyFromJArray(nativeArr, tmpArr.handle, this.handle));
        tmpArr.release();
    }

    public void copyFrom(float[] sourceArray) {
        this.checkCopySize(sourceArray.length);
        if (this.dtype.typeCode != 2 || this.dtype.bits != 32) {
            throw new IllegalArgumentException("Cannot set float[] for " + this.dtype.toString() + " array");
        }
        byte[] nativeArr = new byte[sourceArray.length * this.dtype.numOfBytes];
        for (int i = 0; i < sourceArray.length; ++i) {
            NDArray.wrapBytes(nativeArr, i * this.dtype.numOfBytes, this.dtype.numOfBytes).putFloat(sourceArray[i]);
        }
        NDArray tmpArr = NDArray.empty(this.shape(), this.dtype);
        Base.checkCall(Base._LIB.tvmArrayCopyFromJArray(nativeArr, tmpArr.handle, this.handle));
        tmpArr.release();
    }

    public void copyFrom(long[] sourceArray) {
        this.checkCopySize(sourceArray.length);
        if (this.dtype.typeCode != 0 || this.dtype.bits != 64) {
            throw new IllegalArgumentException("Cannot set long[] for " + this.dtype.toString() + " array");
        }
        byte[] nativeArr = new byte[sourceArray.length * this.dtype.numOfBytes];
        for (int i = 0; i < sourceArray.length; ++i) {
            NDArray.wrapBytes(nativeArr, i * this.dtype.numOfBytes, this.dtype.numOfBytes).putLong(sourceArray[i]);
        }
        NDArray tmpArr = NDArray.empty(this.shape(), this.dtype);
        Base.checkCall(Base._LIB.tvmArrayCopyFromJArray(nativeArr, tmpArr.handle, this.handle));
        tmpArr.release();
    }

    public void copyFrom(int[] sourceArray) {
        this.checkCopySize(sourceArray.length);
        if (this.dtype.typeCode != 0 || this.dtype.bits != 32) {
            throw new IllegalArgumentException("Cannot set int[] for " + this.dtype.toString() + " array");
        }
        byte[] nativeArr = new byte[sourceArray.length * this.dtype.numOfBytes];
        for (int i = 0; i < sourceArray.length; ++i) {
            NDArray.wrapBytes(nativeArr, i * this.dtype.numOfBytes, this.dtype.numOfBytes).putInt(sourceArray[i]);
        }
        NDArray tmpArr = NDArray.empty(this.shape(), this.dtype);
        Base.checkCall(Base._LIB.tvmArrayCopyFromJArray(nativeArr, tmpArr.handle, this.handle));
        tmpArr.release();
    }

    public void copyFrom(short[] sourceArray) {
        this.checkCopySize(sourceArray.length);
        if (this.dtype.typeCode != 0 || this.dtype.bits != 16) {
            throw new IllegalArgumentException("Cannot set short[] for " + this.dtype.toString() + " array");
        }
        byte[] nativeArr = new byte[sourceArray.length * this.dtype.numOfBytes];
        for (int i = 0; i < sourceArray.length; ++i) {
            NDArray.wrapBytes(nativeArr, i * this.dtype.numOfBytes, this.dtype.numOfBytes).putShort(sourceArray[i]);
        }
        NDArray tmpArr = NDArray.empty(this.shape(), this.dtype);
        Base.checkCall(Base._LIB.tvmArrayCopyFromJArray(nativeArr, tmpArr.handle, this.handle));
        tmpArr.release();
    }

    public void copyFrom(byte[] sourceArray) {
        this.checkCopySize(sourceArray.length);
        if (this.dtype.typeCode != 0 || this.dtype.bits != 8) {
            throw new IllegalArgumentException("Cannot set byte[] for " + this.dtype.toString() + " array");
        }
        this.copyFromRaw(sourceArray);
    }

    public void copyFrom(char[] sourceArray) {
        this.checkCopySize(sourceArray.length);
        if (this.dtype.typeCode != 1 || this.dtype.bits != 16) {
            throw new IllegalArgumentException("Cannot set char[] for " + this.dtype.toString() + " array");
        }
        byte[] nativeArr = new byte[sourceArray.length * this.dtype.numOfBytes];
        for (int i = 0; i < sourceArray.length; ++i) {
            NDArray.wrapBytes(nativeArr, i * this.dtype.numOfBytes, this.dtype.numOfBytes).putChar(sourceArray[i]);
        }
        NDArray tmpArr = NDArray.empty(this.shape(), this.dtype);
        Base.checkCall(Base._LIB.tvmArrayCopyFromJArray(nativeArr, tmpArr.handle, this.handle));
        tmpArr.release();
    }

    private void checkCopySize(int sourceLength) {
        long arrSize = this.size();
        if (arrSize != (long)sourceLength) {
            throw new IllegalArgumentException(String.format("Array shape size not match: %d v.s. %d", sourceLength, this.size()));
        }
    }

    public void copyFromRaw(byte[] sourceArray) {
        NDArray tmpArr = NDArray.empty(this.shape(), this.dtype);
        Base.checkCall(Base._LIB.tvmArrayCopyFromJArray(sourceArray, tmpArr.handle, this.handle));
        tmpArr.release();
    }

    public long[] shape() {
        ArrayList<Long> data = new ArrayList<Long>();
        Base.checkCall(Base._LIB.tvmArrayGetShape(this.handle, data));
        long[] shapeArr = new long[data.size()];
        for (int i = 0; i < shapeArr.length; ++i) {
            shapeArr[i] = (Long)data.get(i);
        }
        return shapeArr;
    }

    public long size() {
        long product = 1L;
        long[] shapeArr = this.shape();
        for (int i = 0; i < shapeArr.length; ++i) {
            product *= shapeArr[i];
        }
        return product;
    }

    public double[] asDoubleArray() {
        if (this.dtype.typeCode != 2 || this.dtype.bits != 64) {
            throw new IllegalArgumentException("Cannot set convert to double[] for " + this.dtype.toString() + " array");
        }
        byte[][] units = this.groupInternalBytes();
        double[] array = new double[units.length];
        for (int i = 0; i < units.length; ++i) {
            array[i] = NDArray.wrapBytes(units[i]).getDouble();
        }
        return array;
    }

    public float[] asFloatArray() {
        if (this.dtype.typeCode != 2 || this.dtype.bits != 32) {
            throw new IllegalArgumentException("Cannot set convert to float[] for " + this.dtype.toString() + " array");
        }
        byte[][] units = this.groupInternalBytes();
        float[] array = new float[units.length];
        for (int i = 0; i < units.length; ++i) {
            array[i] = NDArray.wrapBytes(units[i]).getFloat();
        }
        return array;
    }

    public long[] asLongArray() {
        if (this.dtype.typeCode != 0 || this.dtype.bits != 64) {
            throw new IllegalArgumentException("Cannot set convert to long[] for " + this.dtype.toString() + " array");
        }
        byte[][] units = this.groupInternalBytes();
        long[] array = new long[units.length];
        for (int i = 0; i < units.length; ++i) {
            array[i] = NDArray.wrapBytes(units[i]).getLong();
        }
        return array;
    }

    public int[] asIntArray() {
        if (this.dtype.typeCode != 0 || this.dtype.bits != 32) {
            throw new IllegalArgumentException("Cannot set convert to int[] for " + this.dtype.toString() + " array");
        }
        byte[][] units = this.groupInternalBytes();
        int[] array = new int[units.length];
        for (int i = 0; i < units.length; ++i) {
            array[i] = NDArray.wrapBytes(units[i]).getInt();
        }
        return array;
    }

    public short[] asShortArray() {
        if (this.dtype.typeCode != 0 || this.dtype.bits != 16) {
            throw new IllegalArgumentException("Cannot set convert to short[] for " + this.dtype.toString() + " array");
        }
        byte[][] units = this.groupInternalBytes();
        short[] array = new short[units.length];
        for (int i = 0; i < units.length; ++i) {
            array[i] = NDArray.wrapBytes(units[i]).getShort();
        }
        return array;
    }

    public char[] asCharArray() {
        if (this.dtype.typeCode != 1 || this.dtype.bits != 16) {
            throw new IllegalArgumentException("Cannot set convert to char[] for " + this.dtype.toString() + " array");
        }
        byte[][] units = this.groupInternalBytes();
        char[] array = new char[units.length];
        for (int i = 0; i < units.length; ++i) {
            array[i] = NDArray.wrapBytes(units[i]).getChar();
        }
        return array;
    }

    public byte[] asByteArray() {
        if (this.dtype.typeCode != 0 || this.dtype.bits != 8) {
            throw new IllegalArgumentException("Cannot set convert to byte[] for " + this.dtype.toString() + " array");
        }
        return this.internal();
    }

    public byte[] internal() {
        NDArray tmp = NDArray.empty(this.shape(), this.dtype);
        this.copyTo(tmp);
        int arrLength = this.dtype.numOfBytes * (int)this.size();
        byte[] arr = new byte[arrLength];
        Base.checkCall(Base._LIB.tvmArrayCopyToJArray(tmp.handle, arr));
        return arr;
    }

    private byte[][] groupInternalBytes() {
        byte[] raw = this.internal();
        int unitSize = this.dtype.numOfBytes;
        if (raw.length <= 0 || raw.length % unitSize != 0) {
            throw new IllegalArgumentException(String.format("%s size %d cannot divide byte array size %d", this.dtype.toString(), unitSize, raw.length));
        }
        int numOfUnits = raw.length / unitSize;
        byte[][] units = new byte[numOfUnits][unitSize];
        for (int i = 0; i < numOfUnits; ++i) {
            System.arraycopy(raw, i * unitSize, units[i], 0, unitSize);
        }
        return units;
    }

    public TVMContext ctx() {
        return this.context;
    }

    public static NDArray empty(long[] shape, TVMType dtype, TVMContext ctx) {
        Base.RefLong refHandle = new Base.RefLong();
        Base.checkCall(Base._LIB.tvmArrayAlloc(shape, dtype.typeCode, dtype.bits, dtype.lanes, ctx.deviceType, ctx.deviceId, refHandle));
        return new NDArray(refHandle.value, false, dtype, ctx);
    }

    public static NDArray empty(long[] shape, TVMType dtype) {
        return NDArray.empty(shape, dtype, new TVMContext(1, 0));
    }

    public static NDArray empty(long[] shape) {
        return NDArray.empty(shape, new TVMType("float32", 1), new TVMContext(1, 0));
    }

    public static NDArray empty(long[] shape, TVMContext ctx) {
        return NDArray.empty(shape, new TVMType("float32", 1), ctx);
    }

    private static ByteBuffer wrapBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb;
    }

    private static ByteBuffer wrapBytes(byte[] bytes, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, length);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb;
    }
}

