/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class NativeLibraryLoader {
    private static final String libPathInJar = "/lib/native/";
    private static File tempDir;

    NativeLibraryLoader() {
    }

    public static void loadLibrary(String libname) throws UnsatisfiedLinkError, IOException {
        String mappedLibname;
        String loadLibname = mappedLibname = System.mapLibraryName(libname);
        if (mappedLibname.endsWith("dylib")) {
            System.err.println("Replaced .dylib with .jnilib");
            loadLibname = mappedLibname.replace(".dylib", ".jnilib");
        }
        System.err.println("Attempting to load " + loadLibname);
        NativeLibraryLoader.extractResourceFileToTempDir(loadLibname, new Action(){

            @Override
            public void invoke(File target) {
                System.err.println("Loading library from " + target.getPath());
                System.load(target.getPath());
            }
        });
    }

    private static String unifyOSName(String osname) {
        if (osname.startsWith("Windows")) {
            return "Windows";
        }
        return osname;
    }

    private static String getUnifiedOSName() {
        return NativeLibraryLoader.unifyOSName(System.getProperty("os.name"));
    }

    private static File createTempFile(String name) throws IOException {
        return new File(tempDir + File.separator + name);
    }

    public static void extractResourceFileToTempDir(String filename, Action action) throws IOException {
        String libFileInJar = libPathInJar + filename;
        InputStream is = NativeLibraryLoader.class.getResourceAsStream(libFileInJar);
        if (is == null) {
            throw new UnsatisfiedLinkError("Couldn't find the resource " + filename);
        }
        System.err.println(String.format("Loading %s from %s", filename, libPathInJar));
        try {
            File tempfile = NativeLibraryLoader.createTempFile(filename);
            FileOutputStream os = new FileOutputStream(tempfile);
            long savedTime = System.currentTimeMillis();
            byte[] buf = new byte[8192];
            int len = is.read(buf);
            while (len > 0) {
                ((OutputStream)os).write(buf, 0, len);
                len = is.read(buf);
            }
            os.flush();
            FileInputStream lock = new FileInputStream(tempfile);
            ((OutputStream)os).close();
            double seconds = (double)(System.currentTimeMillis() - savedTime) / 1000.0;
            System.err.println(String.format("Copying took %.2f seconds.", seconds));
            action.invoke(tempfile);
            lock.close();
        }
        catch (IOException io) {
            System.err.println("[ERROR] Could not create the temp file: " + io.toString());
            throw io;
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("Couldn't load copied link file: " + ule.toString());
            throw ule;
        }
    }

    static {
        try {
            tempDir = File.createTempFile("tvm4j", "");
            if (!tempDir.delete() || !tempDir.mkdir()) {
                throw new IOException("Couldn't create directory " + tempDir.getAbsolutePath());
            }
            if ("Windows".equals(NativeLibraryLoader.getUnifiedOSName())) {
                throw new RuntimeException("Windows not supported yet.");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    for (File f : tempDir.listFiles()) {
                        System.err.println("Deleting " + f.getAbsolutePath());
                        if (f.delete()) continue;
                        System.err.println("[WARN] Couldn't delete temporary file " + f.getAbsolutePath());
                    }
                    System.err.println("Deleting " + tempDir.getAbsolutePath());
                    if (!tempDir.delete()) {
                        System.err.println("[WARN] Couldn't delete temporary directory " + tempDir.getAbsolutePath());
                    }
                }
            });
        }
        catch (IOException ex) {
            System.err.println("Couldn't create temporary directory: " + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    static interface Action {
        public void invoke(File var1);
    }
}

