/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm;

public class TVMType {
    public static final int INT = 0;
    public static final int UINT = 1;
    public static final int FLOAT = 2;
    public static final int HANDLE = 4;
    public final int typeCode;
    public final int bits;
    public final int numOfBytes;
    public final int lanes;

    public TVMType(String typeStr, int lanes) {
        this.lanes = lanes;
        int bitsTemp = 0;
        if (typeStr.startsWith("int")) {
            this.typeCode = 0;
            bitsTemp = Integer.parseInt(typeStr.substring(3));
        } else if (typeStr.startsWith("uint")) {
            this.typeCode = 1;
            bitsTemp = Integer.parseInt(typeStr.substring(4));
        } else if (typeStr.startsWith("float")) {
            this.typeCode = 2;
            bitsTemp = Integer.parseInt(typeStr.substring(5));
        } else if (typeStr.startsWith("handle")) {
            this.typeCode = 4;
            bitsTemp = 64;
        } else {
            throw new IllegalArgumentException("Do not know how to handle type " + typeStr);
        }
        int n = this.bits = bitsTemp == 0 ? 32 : bitsTemp;
        if ((this.bits & this.bits - 1) != 0 || this.bits < 8) {
            throw new IllegalArgumentException("Do not know how to handle type " + typeStr);
        }
        this.numOfBytes = this.bits / 8;
    }

    public TVMType(String typeStr) {
        this(typeStr, 1);
    }

    public int hashCode() {
        return this.typeCode << 16 | this.bits << 8 | this.lanes;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof TVMType) {
            TVMType otherInst = (TVMType)other;
            return this.bits == otherInst.bits && this.typeCode == otherInst.typeCode && this.lanes == otherInst.lanes;
        }
        return false;
    }

    public String toString() {
        String typeCodeStr;
        switch (this.typeCode) {
            case 0: {
                typeCodeStr = "int";
                break;
            }
            case 1: {
                typeCodeStr = "uint";
                break;
            }
            case 2: {
                typeCodeStr = "float";
                break;
            }
            case 4: {
                typeCodeStr = "handle";
                break;
            }
            default: {
                typeCodeStr = "Unknown";
            }
        }
        String str = typeCodeStr + this.bits;
        if (this.lanes != 1) {
            str = str + this.lanes;
        }
        return str;
    }
}

