/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.tvm.rpc.NativeServerLoop;
import org.apache.tvm.rpc.RPCWatchdog;
import org.apache.tvm.rpc.ServerProcessor;
import org.apache.tvm.rpc.SocketChannel;
import org.apache.tvm.rpc.Utils;

public class ConnectTrackerServerProcessor
implements ServerProcessor {
    private ServerSocket server;
    private final String trackerHost;
    private final int trackerPort;
    private final String key;
    private final String matchKey;
    private int serverPort = 5001;
    public static final int MAX_SERVER_PORT = 5555;
    public static final int TRACKER_TIMEOUT = 6000;
    public static final int RETRY_PERIOD = 6000;
    public static final int STALE_TRACKER_TIMEOUT = 300000;
    public static final int HARD_TIMEOUT_DEFAULT = 300;
    private RPCWatchdog watchdog;
    private Socket trackerSocket;

    public ConnectTrackerServerProcessor(String trackerHost, int trackerPort, String key, RPCWatchdog watchdog) throws IOException {
        while (true) {
            try {
                this.server = new ServerSocket(this.serverPort);
                this.server.setSoTimeout(300000);
            }
            catch (BindException e) {
                System.err.println(this.serverPort);
                System.err.println(e);
                ++this.serverPort;
                if (this.serverPort <= 5555) continue;
                throw e;
            }
            break;
        }
        System.err.println("using port: " + this.serverPort);
        this.trackerHost = trackerHost;
        this.trackerPort = trackerPort;
        this.key = key;
        this.matchKey = key + ":" + Math.random();
        this.watchdog = watchdog;
    }

    public String getMatchKey() {
        return this.matchKey;
    }

    @Override
    public void terminate() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String recvKey = null;
        try {
            this.trackerSocket = this.connectToTracker();
            this.register();
            Socket socket = null;
            InputStream in = null;
            OutputStream out = null;
            block19: while (true) {
                try {
                    while (true) {
                        System.err.println("waiting for requests...");
                        socket = this.server.accept();
                        in = socket.getInputStream();
                        out = socket.getOutputStream();
                        int magic = Utils.wrapBytes(Utils.recvAll(in, 4)).getInt();
                        if (magic != 1045105) {
                            out.write(Utils.toBytes(1045107));
                            System.err.println("incorrect RPC magic");
                            Utils.closeQuietly(socket);
                            continue;
                        }
                        recvKey = Utils.recvString(in);
                        System.err.println("matchKey:" + this.matchKey);
                        System.err.println("key: " + recvKey);
                        if (recvKey.indexOf(this.matchKey) != -1) break block19;
                        out.write(Utils.toBytes(1045107));
                        System.err.println("key mismatch, expected: " + this.matchKey + " got: " + recvKey);
                        Utils.closeQuietly(socket);
                    }
                }
                catch (SocketTimeoutException e) {
                    System.err.println("no incoming connections, refreshing...");
                    if (this.needRefreshKey()) continue;
                    System.err.println("reregistering...");
                    this.register();
                    continue;
                }
                break;
            }
            int timeout = 300;
            int timeoutArgIndex = recvKey.indexOf("-timeout=");
            if (timeoutArgIndex != -1) {
                timeout = Integer.parseInt(recvKey.substring(timeoutArgIndex + "-timeout=".length()));
            }
            System.err.println("alloted timeout: " + timeout);
            if (!recvKey.startsWith("client:")) {
                System.err.println("recv key mismatch...");
                out.write(Utils.toBytes(1045107));
            } else {
                out.write(Utils.toBytes(1045105));
                Utils.sendString(out, recvKey);
            }
            System.err.println("Connection from " + socket.getRemoteSocketAddress().toString());
            this.watchdog.startTimeout(timeout * 1000);
            SocketChannel sockChannel = new SocketChannel(socket);
            new NativeServerLoop(sockChannel.getFsend(), sockChannel.getFrecv()).run();
            System.err.println("Finish serving " + socket.getRemoteSocketAddress().toString());
            Utils.closeQuietly(socket);
        }
        catch (ConnectException e) {
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException e_) {
                System.err.println("interrupted before retrying to connect to tracker...");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.trackerSocket != null) {
                    this.trackerSocket.close();
                }
                this.server.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private Socket connectToTracker() throws IOException {
        this.trackerSocket = new Socket();
        InetSocketAddress address = new InetSocketAddress(this.trackerHost, this.trackerPort);
        this.trackerSocket.connect(address, 6000);
        InputStream trackerIn = this.trackerSocket.getInputStream();
        OutputStream trackerOut = this.trackerSocket.getOutputStream();
        trackerOut.write(Utils.toBytes(193137));
        int trackerMagic = Utils.wrapBytes(Utils.recvAll(trackerIn, 4)).getInt();
        if (trackerMagic != 193137) {
            throw new SocketException("failed to connect to tracker (WRONG MAGIC)");
        }
        String infoJSON = this.generateCinfo(this.key);
        Utils.sendString(trackerOut, infoJSON);
        int recvCode = Integer.parseInt(Utils.recvString(trackerIn));
        if (recvCode != 0) {
            throw new SocketException("failed to connect to tracker (not SUCCESS)");
        }
        return this.trackerSocket;
    }

    private void register() throws IOException {
        InputStream trackerIn = this.trackerSocket.getInputStream();
        OutputStream trackerOut = this.trackerSocket.getOutputStream();
        String putJSON = this.generatePut(3, this.key, this.serverPort, this.matchKey);
        Utils.sendString(trackerOut, putJSON);
        int recvCode = Integer.parseInt(Utils.recvString(trackerIn));
        if (recvCode != 0) {
            throw new SocketException("failed to register with tracker (not SUCCESS)");
        }
        System.err.println("registered with tracker...");
    }

    private boolean needRefreshKey() throws IOException {
        InputStream trackerIn = this.trackerSocket.getInputStream();
        OutputStream trackerOut = this.trackerSocket.getOutputStream();
        String getJSON = this.generateGetPendingMatchKeys(7);
        Utils.sendString(trackerOut, getJSON);
        String recvJSON = Utils.recvString(trackerIn);
        System.err.println("pending matchkeys: " + recvJSON);
        return recvJSON.indexOf(this.matchKey) != -1;
    }

    private String generateCinfo(String key) {
        String cinfo = "{\"key\" : \"server:" + key + "\"}";
        return "[5, " + cinfo + "]";
    }

    private String generatePut(int code, String key, int port, String matchKey) {
        return "[" + code + ", \"" + key + "\", [" + port + ", \"" + matchKey + "\"], null]";
    }

    private String generateGetPendingMatchKeys(int code) {
        return "[" + code + "]";
    }
}

