/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

public class RPCWatchdog
extends Thread {
    private int timeout = 0;
    private boolean started = false;

    public synchronized void startTimeout(int timeout) {
        this.timeout = timeout;
        this.started = true;
        this.notify();
    }

    public synchronized void finishTimeout() {
        this.started = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            RPCWatchdog rPCWatchdog = this;
            synchronized (rPCWatchdog) {
                while (!this.started) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        System.err.println("watchdog interrupted...");
                    }
                }
            }
            rPCWatchdog = this;
            synchronized (rPCWatchdog) {
                while (this.started) {
                    try {
                        System.err.println("waiting for timeout: " + this.timeout);
                        this.wait(this.timeout);
                        if (!this.started) {
                            System.err.println("watchdog woken up, ok...");
                            continue;
                        }
                        System.err.println("watchdog woke up!");
                        System.err.println("terminating...");
                        this.terminate();
                    }
                    catch (InterruptedException e) {
                        System.err.println("watchdog interrupted...");
                    }
                }
            }
        }
    }

    protected void terminate() {
        System.exit(0);
    }
}

