/*
 * Decompiled with CFR 0.152.
 */
package org.c64.attitude.Afterimage.Mode.Data.Row;

import org.c64.attitude.Afterimage.InvalidDataRowIndexException;
import org.c64.attitude.Afterimage.NoDataException;
import org.c64.attitude.Afterimage.Util.Util$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Row$ {
    public static final Row$ MODULE$;
    private final int bitmapRowSize;
    private final int screenRowSize;
    private final int colorsRowSize;

    static {
        new Row$();
    }

    public int bitmapRowSize() {
        return this.bitmapRowSize;
    }

    public int screenRowSize() {
        return this.screenRowSize;
    }

    public int colorsRowSize() {
        return this.colorsRowSize;
    }

    private void validateRowIndex(int index) {
        if (index < 0 || index > 24) {
            throw new InvalidDataRowIndexException(index);
        }
    }

    public byte[] getBitmapRow(int index, byte[] bitmap, int rowSize) {
        this.validateRowIndex(index);
        return (byte[])Predef$.MODULE$.byteArrayOps(bitmap).slice(index * rowSize, (index + 1) * rowSize);
    }

    public int getBitmapRow$default$3() {
        return this.bitmapRowSize();
    }

    public byte[] getScreenRow(int index, byte[] screen, int rowSize) {
        this.validateRowIndex(index);
        return (byte[])Predef$.MODULE$.byteArrayOps(screen).slice(index * rowSize, (index + 1) * rowSize);
    }

    public int getScreenRow$default$3() {
        return this.screenRowSize();
    }

    public byte[] getColorsRow(int index, byte[] colors, int rowSize) {
        this.validateRowIndex(index);
        return (byte[])Predef$.MODULE$.byteArrayOps(colors).slice(index * rowSize, (index + 1) * rowSize);
    }

    public int getColorsRow$default$3() {
        return this.colorsRowSize();
    }

    public byte[] getBitmapRows(int from, int to, byte[] bitmap, int rowSize) {
        this.validateRowIndex(from);
        this.validateRowIndex(to);
        Tuple2<Object, Object> tuple2 = Util$.MODULE$.getOrderedNumbers(from, to);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int indexFrom = tuple2._1$mcI$sp();
            int indexTo = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(indexFrom, indexTo);
            int indexFrom2 = sp3._1$mcI$sp();
            int indexTo2 = sp3._2$mcI$sp();
            return (byte[])Predef$.MODULE$.byteArrayOps(bitmap).slice(indexFrom2 * rowSize, (indexTo2 + 1) * rowSize);
        }
        throw new MatchError(tuple2);
    }

    public int getBitmapRows$default$4() {
        return this.bitmapRowSize();
    }

    public byte[] getScreenRows(int from, int to, byte[] screen, int rowSize) {
        this.validateRowIndex(from);
        this.validateRowIndex(to);
        Tuple2<Object, Object> tuple2 = Util$.MODULE$.getOrderedNumbers(from, to);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int indexFrom = tuple2._1$mcI$sp();
            int indexTo = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(indexFrom, indexTo);
            int indexFrom2 = sp3._1$mcI$sp();
            int indexTo2 = sp3._2$mcI$sp();
            return (byte[])Predef$.MODULE$.byteArrayOps(screen).slice(indexFrom2 * rowSize, (indexTo2 + 1) * rowSize);
        }
        throw new MatchError(tuple2);
    }

    public int getScreenRows$default$4() {
        return this.screenRowSize();
    }

    public byte[] getColorsRows(int from, int to, byte[] colors, int rowSize) {
        this.validateRowIndex(from);
        this.validateRowIndex(to);
        Tuple2<Object, Object> tuple2 = Util$.MODULE$.getOrderedNumbers(from, to);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int indexFrom = tuple2._1$mcI$sp();
            int indexTo = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(indexFrom, indexTo);
            int indexFrom2 = sp3._1$mcI$sp();
            int indexTo2 = sp3._2$mcI$sp();
            return (byte[])Predef$.MODULE$.byteArrayOps(colors).slice(indexFrom2 * rowSize, (indexTo2 + 1) * rowSize);
        }
        throw new MatchError(tuple2);
    }

    public int getColorsRows$default$4() {
        return this.colorsRowSize();
    }

    public String convertDataToCode(byte[] data, int numValues, int indent) {
        if (data.length == 0) {
            throw new NoDataException();
        }
        int dataLengthRounded = Math.round((data.length - 1) / numValues) * numValues + numValues;
        int numLines = dataLengthRounded / numValues;
        String indentation = Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(indent, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return " ";
            }
        }, ClassTag$.MODULE$.apply(String.class))).mkString("");
        return new StringBuilder().append((Object)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numLines - 1).map((Function1)new Serializable(data, numValues, indentation){
            public static final long serialVersionUID = 0L;
            private final byte[] data$1;
            private final int numValues$1;
            private final String indentation$1;

            public final String apply(int line) {
                int from = line * this.numValues$1;
                int until = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper((line + 1) * this.numValues$1), this.data$1.length);
                return new StringBuilder().append((Object)this.indentation$1).append((Object)".db ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(this.data$1).slice(from, until)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(byte by) {
                        return new StringOps(Predef$.MODULE$.augmentString("$%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by)}));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",")).toString();
            }
            {
                this.data$1 = data$1;
                this.numValues$1 = numValues$1;
                this.indentation$1 = indentation$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n")).append((Object)"\n").toString();
    }

    public int convertDataToCode$default$2() {
        return 16;
    }

    public int convertDataToCode$default$3() {
        return 16;
    }

    private Row$() {
        MODULE$ = this;
        this.bitmapRowSize = 320;
        this.screenRowSize = 40;
        this.colorsRowSize = 40;
    }
}

