/*
 * Decompiled with CFR 0.152.
 */
package org.c64.attitude.Afterimage.Colour;

import java.io.InputStream;
import java.io.Serializable;
import org.c64.attitude.Afterimage.Colour.Colour;
import org.c64.attitude.Afterimage.Colour.Colour$;
import org.c64.attitude.Afterimage.Colour.Palette;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Palette$
implements Serializable {
    public static final Palette$ MODULE$ = new Palette$();

    private Palette build(String name) {
        String filename = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("/palettes/%s.json"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name}));
        InputStream inputStream = this.getClass().getResourceAsStream(filename);
        BufferedSource source = Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.UTF8());
        return this.parseJSON(source.mkString());
    }

    private Palette load(String file) {
        BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8());
        return this.parseJSON(source.mkString());
    }

    private Palette parseJSON(String source) {
        List palette = package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(source), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).$bslash("palette").children();
        Colour[] colours = (Colour[])palette.map((Function1 & Serializable)item -> {
            JsonAST.JValue jValue = item;
            if (!(jValue instanceof JsonAST.JObject)) {
                throw new RuntimeException();
            }
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            Colour colour = Colour$.MODULE$.apply((Map<String, Object>)jObject.values());
            return colour;
        }).toArray(ClassTag$.MODULE$.apply(Colour.class));
        return new Palette(colours);
    }

    public Palette apply(String name) {
        Palette palette;
        try {
            palette = this.fromFile(name);
        }
        catch (Throwable throwable) {
            try {
                palette = this.fromTemplate(name);
            }
            catch (Throwable throwable2) {
                throw new RuntimeException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid colour palette: '%s' (no such file or template found)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
        }
        return palette;
    }

    public Palette fromTemplate(String name) {
        Palette palette;
        try {
            palette = this.build(name);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid colour palette template: check '%s' configuration"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        return palette;
    }

    public Palette fromFile(String name) {
        Palette palette;
        try {
            palette = this.load(name);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid colour palette setup: malformed JSON data in '%s' file"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        return palette;
    }

    public Palette apply(Colour[] colours) {
        return new Palette(colours);
    }

    public Option<Colour[]> unapply(Palette x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.colours());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Palette$.class);
    }

    private Palette$() {
    }
}

