/*
 * Decompiled with CFR 0.152.
 */
package org.c64.attitude.Afterimage.Mode.Data.Row;

import java.io.Serializable;
import org.c64.attitude.Afterimage.Util.Util$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class Row$ {
    public static final Row$ MODULE$ = new Row$();
    private static final int bitmapRowSize = 320;
    private static final int screenRowSize = 40;
    private static final int colorsRowSize = 40;

    public int bitmapRowSize() {
        return bitmapRowSize;
    }

    public int screenRowSize() {
        return screenRowSize;
    }

    public int colorsRowSize() {
        return colorsRowSize;
    }

    private void validateRowIndex(int index) {
        Predef$.MODULE$.require(index >= 0 && index <= 24, (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid data row index requested: got %d, but expected an integer between 0 and 24"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})));
    }

    public byte[] getBitmapRow(int index, byte[] bitmap, int rowSize) {
        this.validateRowIndex(index);
        return (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bitmap), index * rowSize, (index + 1) * rowSize);
    }

    public int getBitmapRow$default$3() {
        return this.bitmapRowSize();
    }

    public byte[] getScreenRow(int index, byte[] screen, int rowSize) {
        this.validateRowIndex(index);
        return (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(screen), index * rowSize, (index + 1) * rowSize);
    }

    public int getScreenRow$default$3() {
        return this.screenRowSize();
    }

    public byte[] getColorsRow(int index, byte[] colors, int rowSize) {
        this.validateRowIndex(index);
        return (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(colors), index * rowSize, (index + 1) * rowSize);
    }

    public int getColorsRow$default$3() {
        return this.colorsRowSize();
    }

    public byte[] getBitmapRows(int from, int to, byte[] bitmap, int rowSize) {
        this.validateRowIndex(from);
        this.validateRowIndex(to);
        Tuple2<Object, Object> tuple2 = Util$.MODULE$.getOrderedNumbers(from, to);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int indexFrom = tuple2._1$mcI$sp();
        int indexTo = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(indexFrom, indexTo);
        Tuple2.mcII.sp sp3 = sp2;
        int indexFrom2 = sp3._1$mcI$sp();
        int indexTo2 = sp3._2$mcI$sp();
        return (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bitmap), indexFrom2 * rowSize, (indexTo2 + 1) * rowSize);
    }

    public int getBitmapRows$default$4() {
        return this.bitmapRowSize();
    }

    public byte[] getScreenRows(int from, int to, byte[] screen, int rowSize) {
        this.validateRowIndex(from);
        this.validateRowIndex(to);
        Tuple2<Object, Object> tuple2 = Util$.MODULE$.getOrderedNumbers(from, to);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int indexFrom = tuple2._1$mcI$sp();
        int indexTo = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(indexFrom, indexTo);
        Tuple2.mcII.sp sp3 = sp2;
        int indexFrom2 = sp3._1$mcI$sp();
        int indexTo2 = sp3._2$mcI$sp();
        return (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(screen), indexFrom2 * rowSize, (indexTo2 + 1) * rowSize);
    }

    public int getScreenRows$default$4() {
        return this.screenRowSize();
    }

    public byte[] getColorsRows(int from, int to, byte[] colors, int rowSize) {
        this.validateRowIndex(from);
        this.validateRowIndex(to);
        Tuple2<Object, Object> tuple2 = Util$.MODULE$.getOrderedNumbers(from, to);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int indexFrom = tuple2._1$mcI$sp();
        int indexTo = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(indexFrom, indexTo);
        Tuple2.mcII.sp sp3 = sp2;
        int indexFrom2 = sp3._1$mcI$sp();
        int indexTo2 = sp3._2$mcI$sp();
        return (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(colors), indexFrom2 * rowSize, (indexTo2 + 1) * rowSize);
    }

    public int getColorsRows$default$4() {
        return this.colorsRowSize();
    }

    public String convertDataToCode(byte[] data, int numValues, int indent) {
        Predef$.MODULE$.require(data.length > 0, (Function0 & Serializable)() -> "No data has been provided: cannot process empty data");
        int dataLengthRounded = Math.round((data.length - 1) / numValues) * numValues + numValues;
        int numLines = dataLengthRounded / numValues;
        String indentation = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.fill(indent, (Function0 & Serializable)() -> " ", ClassTag$.MODULE$.apply(String.class))).mkString("");
        return new StringBuilder(1).append(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numLines - 1).map((Function1 & Serializable)line -> Row$.$anonfun$convertDataToCode$3(numValues, data, indentation, BoxesRunTime.unboxToInt((Object)line))).mkString("\n")).append("\n").toString();
    }

    public int convertDataToCode$default$2() {
        return 16;
    }

    public int convertDataToCode$default$3() {
        return 16;
    }

    public static final /* synthetic */ String $anonfun$convertDataToCode$3(int numValues$1, byte[] data$1, String indentation$1, int line) {
        int from = line * numValues$1;
        int until = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper((line + 1) * numValues$1), data$1.length);
        return new StringBuilder(4).append(indentation$1).append(".db ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(data$1), from, until)), (Function1 & Serializable)object -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("$%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)object))})), ClassTag$.MODULE$.apply(String.class))).mkString(",")).toString();
    }

    private Row$() {
    }
}

