/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.gradle.microbench;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.caffinitas.gradle.microbench.MicrobenchExtension;
import org.caffinitas.gradle.microbench.MicrobenchScriptTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.gradle.kotlin.dsl.TaskContainerExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/caffinitas/gradle/microbench/MicrobenchScriptTask;", "Lorg/gradle/api/DefaultTask;", "jarTaskName", "", "(Ljava/lang/String;)V", "scriptFile", "Lorg/gradle/api/file/RegularFileProperty;", "getScriptFile", "()Lorg/gradle/api/file/RegularFileProperty;", "generateScript", "", "gradle-microbench"})
public class MicrobenchScriptTask
extends DefaultTask {
    @OutputFile
    @NotNull
    private final RegularFileProperty scriptFile;
    private final String jarTaskName;

    @NotNull
    public final RegularFileProperty getScriptFile() {
        return this.scriptFile;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generateScript() {
        void $this$named$iv;
        void $this$mapTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer $this$getByType$iv = extensionContainer;
        boolean $i$f$getByType = false;
        ExtensionContainer extensionContainer2 = $this$getByType$iv;
        boolean $i$f$typeOf22 = false;
        TypeOf typeOf = (TypeOf)new TypeOf<SourceSetContainer>(){};
        Object object = extensionContainer2.getByType(typeOf);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getByType(typeOf<T>())");
        Object object2 = ((SourceSetContainer)object).getByName("microbench");
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"project.extensions.getBy\u2026).getByName(\"microbench\")");
        SourceSet srcSet = (SourceSet)object2;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ExtensionContainer extensionContainer3 = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer3, (String)"project.extensions");
        ExtensionContainer $this$getByType$iv2 = extensionContainer3;
        boolean $i$f$getByType2 = false;
        ExtensionContainer $i$f$typeOf22 = $this$getByType$iv2;
        boolean $i$f$typeOf32 = false;
        TypeOf typeOf2 = (TypeOf)new TypeOf<MicrobenchExtension>(){};
        Object object3 = $i$f$typeOf22.getByType(typeOf2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"getByType(typeOf<T>())");
        MicrobenchExtension ext = (MicrobenchExtension)object3;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        File file = project3.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        Collection collection = CollectionsKt.listOf((Object)FilesKt.resolve((File)file, (String)"test/conf"));
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        Object object4 = project4.getConfigurations().named(srcSet.getRuntimeClasspathConfigurationName()).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"project.configurations.n\u2026hConfigurationName).get()");
        Set set = ((Configuration)object4).getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"project.configurations.n\u2026gurationName).get().files");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)set);
        boolean $i$f$map22 = false;
        Iterable $i$f$typeOf32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void f;
            File file2 = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v13 = f;
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"f");
            Project project5 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            File file3 = project5.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.projectDir");
            if (FilesKt.startsWith((File)v13, (File)file3)) {
                StringBuilder stringBuilder = new StringBuilder().append("${BASE}/");
                Project project6 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
                File file4 = project6.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"project.projectDir");
                string = stringBuilder.append(FilesKt.relativeTo((File)f, (File)file4)).toString();
            } else {
                string = f.getAbsolutePath();
            }
            String string2 = string;
            collection2.add(string2);
        }
        List classpathFiles = (List)destination$iv$iv;
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        TaskContainer taskContainer = project7.getTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"project.tasks");
        TaskCollection $i$f$map22 = (TaskCollection)taskContainer;
        String name$iv = this.jarTaskName;
        boolean $i$f$named = false;
        TaskProvider jar2 = TaskContainerExtensionsKt.named((TaskCollection)$this$named$iv, (String)name$iv, (KClass)Reflection.getOrCreateKotlinClass(Jar.class));
        StringBuilder stringBuilder = new StringBuilder().append("#!/bin/bash\n#\n# GENERATED FILE\n#\n# JMH wrapper shell script for ");
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        StringBuilder stringBuilder2 = stringBuilder.append(project8.getPath()).append(" for Java ");
        JavaVersion javaVersion = JavaVersion.current();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaVersion, (String)"JavaVersion.current()");
        StringBuilder stringBuilder3 = stringBuilder2.append(javaVersion.getMajorVersion()).append("\n#\n# DO NOT EDIT, ALL CHANGES IN THE ORIGINAL LOCATION WILL BE OVERWRITTEN (or copy it to a safe place)\n#\n\nBASE=\"");
        Project project9 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project9, (String)"project");
        StringBuilder stringBuilder4 = stringBuilder3.append(project9.getProjectDir()).append("\"\n\nCLASSPATH=\"");
        Object object5 = jar2.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"jar.get()");
        Object object6 = ((Jar)object5).getArchiveFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"jar.get().archiveFile.get()");
        StringBuilder stringBuilder5 = stringBuilder4.append(((RegularFile)object6).getAsFile()).append("\"\n").append(CollectionsKt.joinToString$default((Iterable)classpathFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)generateScript.script.1.INSTANCE, (int)30, null)).append("\n\njava -cp ${CLASSPATH} \\\n    ");
        Object object7 = ext.getJvmOptions().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"ext.jvmOptions.get()");
        String script2 = stringBuilder5.append(CollectionsKt.joinToString$default((Iterable)((Iterable)object7), (CharSequence)" \\\n    ", null, null, (int)0, null, null, (int)62, null)).append(" \\\n    org.openjdk.jmh.Main \\\n    \"$@\"\n").toString();
        Object object8 = this.scriptFile.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object8, (String)"scriptFile.get()");
        File file5 = ((RegularFile)object8).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"scriptFile.get().asFile");
        File outFile = file5;
        FilesKt.writeText$default((File)outFile, (String)script2, null, (int)2, null);
        outFile.setExecutable(true);
        this.getLogger().lifecycle("Wrote executable {}", new Object[]{outFile});
    }

    @Inject
    public MicrobenchScriptTask(@NotNull String jarTaskName) {
        Intrinsics.checkParameterIsNotNull((Object)jarTaskName, (String)"jarTaskName");
        this.jarTaskName = jarTaskName;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        RegularFileProperty regularFileProperty = project.getObjects().fileProperty();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ProjectLayout projectLayout = project2.getLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout, (String)"project.layout");
        RegularFileProperty regularFileProperty2 = regularFileProperty.convention(projectLayout.getBuildDirectory().file("microbench"));
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty2, (String)"project.objects.fileProp\u2026hPlugin.SOURCE_SET_NAME))");
        this.scriptFile = regularFileProperty2;
        this.setGroup("build");
        this.setDescription("Generate the shell wrapper to run microbenchmarks");
    }
}

