/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.AbstractTracingAwareExecutorService;
import org.apache.cassandra.concurrent.SEPWorker;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.apache.cassandra.utils.concurrent.WaitQueue;

public class SEPExecutor
extends AbstractTracingAwareExecutorService {
    private final SharedExecutorPool pool;
    private final int maxWorkers;
    private final int maxTasksQueued;
    private final AtomicLong permits = new AtomicLong();
    private final WaitQueue hasRoom = new WaitQueue();
    private final AtomicLong totalBlocked = new AtomicLong();
    private final AtomicInteger currentlyBlocked = new AtomicInteger();
    private final AtomicLong completedTasks = new AtomicLong();
    volatile boolean shuttingDown = false;
    final SimpleCondition shutdown = new SimpleCondition();
    protected final ConcurrentLinkedQueue<AbstractTracingAwareExecutorService.FutureTask<?>> tasks = new ConcurrentLinkedQueue();

    SEPExecutor(SharedExecutorPool pool, int maxWorkers, int maxTasksQueued) {
        this.pool = pool;
        this.maxWorkers = maxWorkers;
        this.maxTasksQueued = maxTasksQueued;
        this.permits.set(SEPExecutor.combine(0, maxWorkers));
    }

    @Override
    protected void onCompletion() {
        this.completedTasks.incrementAndGet();
    }

    boolean maybeSchedule() {
        if (this.pool.spinningCount.get() > 0 || !this.takeWorkPermit(true)) {
            return false;
        }
        this.pool.schedule(new SEPWorker.Work(this));
        return true;
    }

    @Override
    protected void addTask(AbstractTracingAwareExecutorService.FutureTask<?> task) {
        int taskPermits;
        long current;
        this.tasks.add(task);
        while (!this.permits.compareAndSet(current = this.permits.get(), SEPExecutor.updateTaskPermits(current, (taskPermits = SEPExecutor.taskPermits(current)) + 1))) {
        }
        if (taskPermits == 0) {
            this.pool.maybeStartSpinningWorker();
        } else if (taskPermits >= this.maxTasksQueued) {
            WaitQueue.Signal s = this.hasRoom.register();
            if (SEPExecutor.taskPermits(this.permits.get()) > this.maxTasksQueued) {
                if (this.takeWorkPermit(true)) {
                    this.pool.schedule(new SEPWorker.Work(this));
                }
                this.totalBlocked.incrementAndGet();
                this.currentlyBlocked.incrementAndGet();
                s.awaitUninterruptibly();
                this.currentlyBlocked.decrementAndGet();
            } else {
                s.cancel();
            }
        }
    }

    boolean takeTaskPermit() {
        int taskPermits;
        long current;
        do {
            if ((taskPermits = SEPExecutor.taskPermits(current = this.permits.get())) != 0) continue;
            return false;
        } while (!this.permits.compareAndSet(current, SEPExecutor.updateTaskPermits(current, taskPermits - 1)));
        if (taskPermits == this.maxTasksQueued && this.hasRoom.hasWaiters()) {
            this.hasRoom.signalAll();
        }
        return true;
    }

    boolean takeWorkPermit(boolean takeTaskPermit) {
        int workPermits;
        int taskPermits;
        long current;
        int taskDelta = takeTaskPermit ? 1 : 0;
        do {
            current = this.permits.get();
            workPermits = SEPExecutor.workPermits(current);
            taskPermits = SEPExecutor.taskPermits(current);
            if (workPermits != 0 && taskPermits != 0) continue;
            return false;
        } while (!this.permits.compareAndSet(current, SEPExecutor.combine(taskPermits - taskDelta, workPermits - 1)));
        if (takeTaskPermit && taskPermits == this.maxTasksQueued && this.hasRoom.hasWaiters()) {
            this.hasRoom.signalAll();
        }
        return true;
    }

    void returnWorkPermit() {
        int workPermits;
        long current;
        while (!this.permits.compareAndSet(current = this.permits.get(), SEPExecutor.updateWorkPermits(current, (workPermits = SEPExecutor.workPermits(current)) + 1))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeExecuteImmediately(Runnable command) {
        AbstractTracingAwareExecutorService.FutureTask<Object> ft = this.newTaskFor(command, null);
        if (!this.takeWorkPermit(false)) {
            this.addTask(ft);
        } else {
            try {
                ft.run();
            }
            finally {
                this.returnWorkPermit();
                this.maybeSchedule();
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        this.shuttingDown = true;
        this.pool.executors.remove(this);
        if (this.getActiveCount() == 0) {
            this.shutdown.signalAll();
        }
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.shutdown();
        ArrayList<Runnable> aborted = new ArrayList<Runnable>();
        while (this.takeTaskPermit()) {
            aborted.add(this.tasks.poll());
        }
        return aborted;
    }

    @Override
    public boolean isShutdown() {
        return this.shuttingDown;
    }

    @Override
    public boolean isTerminated() {
        return this.shuttingDown && this.shutdown.isSignaled();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.shutdown.await(timeout, unit);
        return this.isTerminated();
    }

    public long getPendingTasks() {
        return SEPExecutor.taskPermits(this.permits.get());
    }

    public long getCompletedTasks() {
        return this.completedTasks.get();
    }

    public int getActiveCount() {
        return this.maxWorkers - SEPExecutor.workPermits(this.permits.get());
    }

    public int getTotalBlockedTasks() {
        return (int)this.totalBlocked.get();
    }

    public int getMaximumThreads() {
        return this.maxWorkers;
    }

    public int getCurrentlyBlockedTasks() {
        return this.currentlyBlocked.get();
    }

    private static int taskPermits(long both) {
        return (int)both;
    }

    private static int workPermits(long both) {
        return (int)(both >>> 32);
    }

    private static long updateTaskPermits(long prev, int taskPermits) {
        return prev & 0xFFFFFFFF00000000L | (long)taskPermits;
    }

    private static long updateWorkPermits(long prev, int workPermits) {
        return (long)workPermits << 32 | prev & 0xFFFFFFFFL;
    }

    private static long combine(int taskPermits, int workPermits) {
        return (long)workPermits << 32 | (long)taskPermits;
    }
}

