/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.RateLimiter;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.streaming.StreamManagerMBean;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.management.StreamEventJMXNotifier;
import org.apache.cassandra.streaming.management.StreamStateCompositeData;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class StreamManager
implements StreamManagerMBean {
    public static final StreamManager instance = new StreamManager();
    private final StreamEventJMXNotifier notifier = new StreamEventJMXNotifier();
    private final Map<UUID, StreamResultFuture> initiatedStreams = new NonBlockingHashMap();
    private final Map<UUID, StreamResultFuture> receivingStreams = new NonBlockingHashMap();

    public static StreamRateLimiter getRateLimiter(InetAddress peer) {
        return new StreamRateLimiter(peer);
    }

    @Override
    public Set<CompositeData> getCurrentStreams() {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.concat(this.initiatedStreams.values(), this.receivingStreams.values()), (Function)new Function<StreamResultFuture, CompositeData>(){

            public CompositeData apply(StreamResultFuture input) {
                return StreamStateCompositeData.toCompositeData(input.getCurrentState());
            }
        }));
    }

    public void register(final StreamResultFuture result) {
        result.addEventListener(this.notifier);
        result.addListener(new Runnable(){

            @Override
            public void run() {
                StreamManager.this.initiatedStreams.remove(result.planId);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.initiatedStreams.put(result.planId, result);
    }

    public void registerReceiving(final StreamResultFuture result) {
        result.addEventListener(this.notifier);
        result.addListener(new Runnable(){

            @Override
            public void run() {
                StreamManager.this.receivingStreams.remove(result.planId);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.receivingStreams.put(result.planId, result);
    }

    public StreamResultFuture getReceivingStream(UUID planId) {
        return this.receivingStreams.get(planId);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notifier.getNotificationInfo();
    }

    public static class StreamRateLimiter {
        private static final double ONE_MEGA_BIT = 131072.0;
        private static final RateLimiter limiter = RateLimiter.create((double)Double.MAX_VALUE);
        private static final RateLimiter interDCLimiter = RateLimiter.create((double)Double.MAX_VALUE);
        private final boolean isLocalDC;

        public StreamRateLimiter(InetAddress peer) {
            double throughput = (double)DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec() * 131072.0;
            this.mayUpdateThroughput(throughput, limiter);
            double interDCThroughput = (double)DatabaseDescriptor.getInterDCStreamThroughputOutboundMegabitsPerSec() * 131072.0;
            this.mayUpdateThroughput(interDCThroughput, interDCLimiter);
            this.isLocalDC = DatabaseDescriptor.getLocalDataCenter() != null && DatabaseDescriptor.getEndpointSnitch() != null ? DatabaseDescriptor.getLocalDataCenter().equals(DatabaseDescriptor.getEndpointSnitch().getDatacenter(peer)) : true;
        }

        private void mayUpdateThroughput(double limit, RateLimiter rateLimiter) {
            if (limit == 0.0) {
                limit = Double.MAX_VALUE;
            }
            if (rateLimiter.getRate() != limit) {
                rateLimiter.setRate(limit);
            }
        }

        public void acquire(int toTransfer) {
            limiter.acquire(toTransfer);
            if (!this.isLocalDC) {
                interDCLimiter.acquire(toTransfer);
            }
        }
    }
}

