/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.caffinitas.ohc.CacheSerializer;

public final class BenchmarkUtils {
    public static final CacheSerializer<byte[]> serializer = new CacheSerializer<byte[]>(){

        @Override
        public void serialize(byte[] bytes, DataOutput stream) throws IOException {
            stream.writeInt(bytes.length);
            stream.write(bytes);
        }

        @Override
        public byte[] deserialize(DataInput stream) throws IOException {
            byte[] bytes = new byte[stream.readInt()];
            stream.readFully(bytes);
            return bytes;
        }

        @Override
        public int serializedSize(byte[] t) {
            return t.length + 4;
        }
    };
    public static final CacheSerializer<Long> longSerializer = new CacheSerializer<Long>(){

        @Override
        public void serialize(Long val, DataOutput out) throws IOException {
            out.writeLong(val);
        }

        @Override
        public Long deserialize(DataInput in) throws IOException {
            return in.readLong();
        }

        @Override
        public int serializedSize(Long aLong) {
            return 8;
        }
    };
}

