/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc;

import java.lang.reflect.InvocationTargetException;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.linked.OHCacheImpl;

public class OHCacheBuilder<K, V> {
    private int segmentCount = OHCacheBuilder.roundUpToPowerOf2(Runtime.getRuntime().availableProcessors() * 2, 0x40000000);
    private int hashTableSize = 8192;
    private int bucketLength = 8;
    private long capacity = 0x4000000L;
    private CacheSerializer<K> keySerializer;
    private CacheSerializer<V> valueSerializer;
    private float loadFactor = 0.75f;
    private long maxEntrySize;
    private Class<? extends OHCache> type = OHCacheImpl.class;

    private OHCacheBuilder() {
    }

    static int roundUpToPowerOf2(int number, int max) {
        return number >= max ? max : (number > 1 ? Integer.highestOneBit(number - 1 << 1) : 1);
    }

    public static <K, V> OHCacheBuilder<K, V> newBuilder() {
        return new OHCacheBuilder<K, V>();
    }

    public OHCache<K, V> build() {
        try {
            return this.type.getDeclaredConstructor(OHCacheBuilder.class).newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends OHCache> getType() {
        return this.type;
    }

    public OHCacheBuilder<K, V> type(Class<? extends OHCache> type) {
        this.type = type;
        return this;
    }

    public int getHashTableSize() {
        return this.hashTableSize;
    }

    public OHCacheBuilder<K, V> hashTableSize(int hashTableSize) {
        this.hashTableSize = hashTableSize;
        return this;
    }

    public int getBucketLength() {
        return this.bucketLength;
    }

    public OHCacheBuilder<K, V> setBucketLength(int bucketLength) {
        this.bucketLength = bucketLength;
        return this;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public OHCacheBuilder<K, V> capacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public CacheSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OHCacheBuilder<K, V> keySerializer(CacheSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public CacheSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public OHCacheBuilder<K, V> valueSerializer(CacheSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public OHCacheBuilder<K, V> segmentCount(int segmentCount) {
        this.segmentCount = segmentCount;
        return this;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public OHCacheBuilder<K, V> loadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
        return this;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public OHCacheBuilder<K, V> maxEntrySize(long maxEntrySize) {
        this.maxEntrySize = maxEntrySize;
        return this;
    }
}

