/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.util.Arrays;
import org.caffinitas.ohc.linked.KeyBuffer;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

final class HashEntries {
    private static final boolean MEM_BUFFERS_ENABLE = Boolean.parseBoolean(System.getProperty("MEM_BUFFERS_ENABLE", "false"));
    private static final int BLOCK_BUFFERS = 512;
    private static final long[] memBuffers = new long[1536];
    static final long BLOCK_SIZE = 16384L;
    static final long BLOCK_MASK = 16383L;
    private static final long MAX_BUFFERED_SIZE = 0x800000L;
    static long memBufferHit;
    static long memBufferMiss;
    static long memBufferFree;
    static long memBufferExpires;
    static long memBufferClear;

    HashEntries() {
    }

    static void init(long hash, long keyLen, long valueLen, long hashEntryAdr) {
        Uns.putLong(hashEntryAdr, 32L, hash);
        HashEntries.setNext(hashEntryAdr, 0L);
        Uns.putLong(hashEntryAdr, 48L, keyLen);
        Uns.putLong(hashEntryAdr, 40L, valueLen);
        Uns.putLong(hashEntryAdr, 24L, 1L);
    }

    static boolean compareKey(long hashEntryAdr, KeyBuffer key, long serKeyLen) {
        if (hashEntryAdr == 0L) {
            return false;
        }
        long blkOff = 56L;
        int p = 0;
        byte[] arr = key.array();
        while ((long)p <= serKeyLen - 8L) {
            if (Uns.getLong(hashEntryAdr, blkOff) != Uns.getLongFromByteArray(arr, p)) {
                return false;
            }
            p += 8;
            blkOff += 8L;
        }
        while ((long)p <= serKeyLen - 4L) {
            if (Uns.getInt(hashEntryAdr, blkOff) != Uns.getIntFromByteArray(arr, p)) {
                return false;
            }
            p += 4;
            blkOff += 4L;
        }
        while ((long)p <= serKeyLen - 2L) {
            if (Uns.getShort(hashEntryAdr, blkOff) != Uns.getShortFromByteArray(arr, p)) {
                return false;
            }
            p += 2;
            blkOff += 2L;
        }
        while ((long)p < serKeyLen) {
            if (Uns.getByte(hashEntryAdr, blkOff) != arr[p]) {
                return false;
            }
            ++p;
            ++blkOff;
        }
        return true;
    }

    static boolean compare(long hashEntryAdr, long offset, long otherHashEntryAdr, long otherOffset, long len) {
        if (hashEntryAdr == 0L) {
            return false;
        }
        int p = 0;
        while ((long)p <= len - 8L) {
            if (Uns.getLong(hashEntryAdr, offset) != Uns.getLong(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 8;
            offset += 8L;
            otherOffset += 8L;
        }
        while ((long)p <= len - 4L) {
            if (Uns.getInt(hashEntryAdr, offset) != Uns.getInt(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 4;
            offset += 4L;
            otherOffset += 4L;
        }
        while ((long)p <= len - 2L) {
            if (Uns.getShort(hashEntryAdr, offset) != Uns.getShort(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 2;
            offset += 2L;
            otherOffset += 2L;
        }
        while ((long)p < len) {
            if (Uns.getByte(hashEntryAdr, offset) != Uns.getByte(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            ++p;
            ++offset;
            ++otherOffset;
        }
        return true;
    }

    public static long getLRUNext(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 0L);
    }

    public static void setLRUNext(long hashEntryAdr, long replacement) {
        Uns.putLong(hashEntryAdr, 0L, replacement);
    }

    public static long getAndSetLRUNext(long hashEntryAdr, long replacement) {
        return Uns.getAndPutLong(hashEntryAdr, 0L, replacement);
    }

    public static long getLRUPrev(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 8L);
    }

    public static void setLRUPrev(long hashEntryAdr, long replacement) {
        Uns.putLong(hashEntryAdr, 8L, replacement);
    }

    public static long getAndSetLRUPrev(long hashEntryAdr, long replacement) {
        return Uns.getAndPutLong(hashEntryAdr, 8L, replacement);
    }

    static long getHash(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 32L);
    }

    static long getNext(long hashEntryAdr) {
        return hashEntryAdr != 0L ? Uns.getLong(hashEntryAdr, 16L) : 0L;
    }

    static void setNext(long hashEntryAdr, long nextAdr) {
        if (hashEntryAdr == nextAdr) {
            throw new IllegalArgumentException();
        }
        if (hashEntryAdr != 0L) {
            Uns.putLong(hashEntryAdr, 16L, nextAdr);
        }
    }

    static long getKeyLen(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 48L);
    }

    static long getValueLen(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 40L);
    }

    static long getAllocLen(long address) {
        return Util.allocLen(HashEntries.getKeyLen(address), HashEntries.getValueLen(address));
    }

    static void reference(long hashEntryAdr) {
        Uns.increment(hashEntryAdr, 24L);
    }

    static boolean dereference(long hashEntryAdr) {
        if (Uns.decrement(hashEntryAdr, 24L)) {
            HashEntries.free(hashEntryAdr, HashEntries.getAllocLen(hashEntryAdr));
            return true;
        }
        return false;
    }

    static long allocate(long bytes) {
        if (MEM_BUFFERS_ENABLE && bytes <= 0x800000L) {
            long blockAllocLen = HashEntries.blockAllocLen(bytes);
            long adr = HashEntries.reuseMemBuffer(blockAllocLen);
            if (adr != 0L) {
                ++memBufferHit;
                return adr;
            }
            ++memBufferMiss;
            return Uns.allocate(blockAllocLen);
        }
        return Uns.allocate(bytes);
    }

    static void free(long address, long allocLen) {
        if (address == 0L) {
            return;
        }
        if (MEM_BUFFERS_ENABLE && allocLen <= 0x800000L) {
            address = HashEntries.releaseToMemBuffer(address, HashEntries.blockAllocLen(allocLen));
        }
        Uns.free(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long reuseMemBuffer(long blockAllocLen) {
        long[] lArray = memBuffers;
        synchronized (memBuffers) {
            for (int i = 0; i < memBuffers.length; i += 3) {
                long mbAdr = memBuffers[i];
                if (mbAdr == 0L || memBuffers[i + 1] != blockAllocLen) continue;
                HashEntries.memBuffers[i] = 0L;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return mbAdr;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long releaseToMemBuffer(long address, long allocLen) {
        long[] lArray = memBuffers;
        synchronized (memBuffers) {
            ++memBufferFree;
            long blockAllocLen = HashEntries.blockAllocLen(allocLen);
            long least = Long.MAX_VALUE;
            int min = -1;
            for (int i = 0; i < memBuffers.length; i += 3) {
                if (memBuffers[i] == 0L) {
                    HashEntries.memBuffers[i] = address;
                    HashEntries.memBuffers[i + 1] = blockAllocLen;
                    HashEntries.memBuffers[i + 2] = System.currentTimeMillis();
                    // ** MonitorExit[var4_2] (shouldn't be in output)
                    return 0L;
                }
                long ts = memBuffers[i + 2];
                if (ts >= least) continue;
                least = ts;
                min = i;
            }
            assert (min != -1);
            ++memBufferExpires;
            long freeAddress = memBuffers[min];
            HashEntries.memBuffers[min] = address;
            HashEntries.memBuffers[min + 1] = blockAllocLen;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return freeAddress;
        }
    }

    static long blockAllocLen(long allocLen) {
        if ((allocLen & 0x3FFFL) == 0L) {
            return allocLen;
        }
        return (allocLen & 0xFFFFFFFFFFFFC000L) + 16384L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void memBufferClear() {
        long[] lArray = memBuffers;
        synchronized (memBuffers) {
            ++memBufferClear;
            for (int i = 0; i < memBuffers.length; i += 3) {
                Uns.free(memBuffers[i]);
            }
            Arrays.fill(memBuffers, 0L);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

