/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.concurrent.TracingAwareExecutorService;
import org.apache.cassandra.metrics.SEPMetrics;

public class JMXEnabledSharedExecutorPool
extends SharedExecutorPool {
    public static final JMXEnabledSharedExecutorPool SHARED = new JMXEnabledSharedExecutorPool("SharedPool");

    public JMXEnabledSharedExecutorPool(String poolName) {
        super(poolName);
    }

    public TracingAwareExecutorService newExecutor(int maxConcurrency, int maxQueuedTasks, String name, String jmxPath) {
        JMXEnabledSEPExecutor executor = new JMXEnabledSEPExecutor(maxConcurrency, maxQueuedTasks, name, jmxPath);
        this.executors.add(executor);
        return executor;
    }

    public class JMXEnabledSEPExecutor
    extends SEPExecutor
    implements JMXEnabledSEPExecutorMBean {
        private final SEPMetrics metrics;
        private final String mbeanName;

        public JMXEnabledSEPExecutor(int poolSize, int maxQueuedLength, String name, String jmxPath) {
            super(JMXEnabledSharedExecutorPool.this, poolSize, maxQueuedLength);
            this.metrics = new SEPMetrics(this, jmxPath, name);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.mbeanName = "org.apache.cassandra." + jmxPath + ":type=" + name;
            try {
                mbs.registerMBean(this, new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void unregisterMBean() {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.metrics.release();
        }

        @Override
        public synchronized void shutdown() {
            if (!this.isShutdown()) {
                this.unregisterMBean();
            }
            super.shutdown();
        }

        @Override
        public int getCoreThreads() {
            return 0;
        }

        @Override
        public void setCoreThreads(int number) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMaximumThreads(int number) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface JMXEnabledSEPExecutorMBean
    extends JMXEnabledThreadPoolExecutorMBean {
    }
}

