/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.ExpiredTraceState;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    public static final String TRACE_KS = "system_traces";
    public static final String EVENTS_CF = "events";
    public static final String SESSIONS_CF = "sessions";
    public static final String TRACE_HEADER = "TraceSession";
    private static final int TTL = 86400;
    private static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private final InetAddress localAddress = FBUtilities.getLocalAddress();
    private final ThreadLocal<TraceState> state = new ThreadLocal();
    private final ConcurrentMap<UUID, TraceState> sessions = new ConcurrentHashMap<UUID, TraceState>();
    public static final Tracing instance = new Tracing();

    public static void addColumn(ColumnFamily cf, CellName name, InetAddress address) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(address));
    }

    public static void addColumn(ColumnFamily cf, CellName name, int value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, CellName name, long value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, CellName name, String value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    private static void addColumn(ColumnFamily cf, CellName name, ByteBuffer value) {
        cf.addColumn(new BufferExpiringCell(name, value, System.currentTimeMillis(), 86400));
    }

    public void addParameterColumns(ColumnFamily cf, Map<String, String> rawPayload) {
        for (Map.Entry<String, String> entry : rawPayload.entrySet()) {
            cf.addColumn(new BufferExpiringCell(Tracing.buildName(CFMetaData.TraceSessionsCf, "parameters", entry.getKey()), ByteBufferUtil.bytes(entry.getValue()), System.currentTimeMillis(), 86400));
        }
    }

    public static CellName buildName(CFMetaData meta, Object ... args) {
        return meta.comparator.makeCellName(args);
    }

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return this.state.get().sessionId;
    }

    public static boolean isTracing() {
        return Tracing.instance.state.get() != null;
    }

    public UUID newSession() {
        return this.newSession((UUID)TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())));
    }

    public UUID newSession(UUID sessionId) {
        assert (this.state.get() == null);
        TraceState ts = new TraceState(this.localAddress, sessionId);
        this.state.set(ts);
        this.sessions.put(sessionId, ts);
        return sessionId;
    }

    public void doneWithNonLocalSession(TraceState state) {
        if (state.releaseReference() == 0) {
            this.sessions.remove(state.sessionId);
        }
    }

    public void stopSession() {
        TraceState state = this.state.get();
        if (state == null) {
            logger.debug("request complete");
        } else {
            final int elapsed = state.elapsed();
            final ByteBuffer sessionIdBytes = state.sessionIdBytes;
            StageManager.getStage(Stage.TRACING).execute(new Runnable(){

                @Override
                public void run() {
                    CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                    ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(cfMeta);
                    Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, "duration"), elapsed);
                    Tracing.mutateWithCatch(new Mutation(Tracing.TRACE_KS, sessionIdBytes, cf));
                }
            });
            this.sessions.remove(state.sessionId);
            this.state.set(null);
        }
    }

    public TraceState get() {
        return this.state.get();
    }

    public TraceState get(UUID sessionId) {
        return (TraceState)this.sessions.get(sessionId);
    }

    public void set(TraceState tls) {
        this.state.set(tls);
    }

    public void begin(final String request, final Map<String, String> parameters) {
        assert (Tracing.isTracing());
        final long started_at = System.currentTimeMillis();
        final ByteBuffer sessionIdBytes = this.state.get().sessionIdBytes;
        StageManager.getStage(Stage.TRACING).execute(new Runnable(){

            @Override
            public void run() {
                CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(cfMeta);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, "coordinator"), FBUtilities.getBroadcastAddress());
                Tracing.this.addParameterColumns(cf, parameters);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("request")), request);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("started_at")), started_at);
                Tracing.this.addParameterColumns(cf, parameters);
                Tracing.mutateWithCatch(new Mutation(Tracing.TRACE_KS, sessionIdBytes, cf));
            }
        });
    }

    public TraceState initializeFromMessage(MessageIn<?> message) {
        byte[] sessionBytes = message.parameters.get(TRACE_HEADER);
        if (sessionBytes == null) {
            return null;
        }
        assert (sessionBytes.length == 16);
        UUID sessionId = UUIDGen.getUUID(ByteBuffer.wrap(sessionBytes));
        TraceState ts = (TraceState)this.sessions.get(sessionId);
        if (ts != null && ts.acquireReference()) {
            return ts;
        }
        if (message.verb == MessagingService.Verb.REQUEST_RESPONSE) {
            return new ExpiredTraceState(sessionId);
        }
        ts = new TraceState(message.from, sessionId);
        this.sessions.put(sessionId, ts);
        return ts;
    }

    public static void trace(String message) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(message);
    }

    public static void trace(String format, Object arg) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg1, arg2);
    }

    public static void trace(String format, Object[] args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    static void mutateWithCatch(Mutation mutation) {
        try {
            StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
        }
        catch (UnavailableException | WriteTimeoutException e) {
            throw new AssertionError((Object)e);
        }
        catch (OverloadedException e) {
            logger.warn("Too many nodes are overloaded to save trace events");
        }
    }
}

