/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ReferenceOpenHashBigSet<K>
extends AbstractReferenceSet<K>
implements Serializable,
Cloneable,
Hash,
Size64 {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[][] key;
    protected transient boolean[][] used;
    protected final float f;
    protected transient long n;
    protected transient long maxFill;
    protected transient long mask;
    protected transient int segmentMask;
    protected transient int baseMask;
    protected long size;

    private void initMasks() {
        this.mask = this.n - 1L;
        this.segmentMask = this.key[0].length - 1;
        this.baseMask = this.key.length - 1;
    }

    public ReferenceOpenHashBigSet(long expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (this.n < 0L) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.bigArraySize(expected, f);
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = ObjectBigArrays.newBigArray(this.n);
        this.used = BooleanBigArrays.newBigArray(this.n);
        this.initMasks();
    }

    public ReferenceOpenHashBigSet(long expected) {
        this(expected, 0.75f);
    }

    public ReferenceOpenHashBigSet() {
        this(16L, 0.75f);
    }

    public ReferenceOpenHashBigSet(Collection<? extends K> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public ReferenceOpenHashBigSet(Collection<? extends K> c) {
        this(c, 0.75f);
    }

    public ReferenceOpenHashBigSet(ReferenceCollection<? extends K> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public ReferenceOpenHashBigSet(ReferenceCollection<? extends K> c) {
        this(c, 0.75f);
    }

    public ReferenceOpenHashBigSet(ObjectIterator<K> i, float f) {
        this(16L, f);
        while (i.hasNext()) {
            this.add((K)i.next());
        }
    }

    public ReferenceOpenHashBigSet(ObjectIterator<K> i) {
        this(i, 0.75f);
    }

    public ReferenceOpenHashBigSet(K[] a, int offset, int length, float f) {
        this(length < 0 ? 0L : (long)length, f);
        ObjectArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public ReferenceOpenHashBigSet(K[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public ReferenceOpenHashBigSet(K[] a, float f) {
        this(a, 0, a.length, f);
    }

    public ReferenceOpenHashBigSet(K[] a) {
        this(a, 0.75f);
    }

    @Override
    public boolean add(K k) {
        long h = k == null ? -9148929187392628276L : HashCommon.murmurHash3((long)System.identityHashCode(k) ^ this.mask);
        int displ = (int)(h & (long)this.segmentMask);
        int base = (int)((h & this.mask) >>> 27);
        while (this.used[base][displ]) {
            if (this.key[base][displ] == k) {
                return false;
            }
            base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
        }
        this.used[base][displ] = true;
        this.key[base][displ] = k;
        if (++this.size >= this.maxFill) {
            this.rehash(2L * this.n);
        }
        return true;
    }

    protected final long shiftKeys(long pos) {
        long last;
        while (true) {
            last = pos;
            pos = last + 1L & this.mask;
            while (BooleanBigArrays.get(this.used, pos)) {
                long slot = (ObjectBigArrays.get(this.key, pos) == null ? -9148929187392628276L : HashCommon.murmurHash3((long)System.identityHashCode(ObjectBigArrays.get(this.key, pos)) ^ this.mask)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1L & this.mask;
            }
            if (!BooleanBigArrays.get(this.used, pos)) break;
            ObjectBigArrays.set(this.key, last, ObjectBigArrays.get(this.key, pos));
        }
        BooleanBigArrays.set(this.used, last, false);
        ObjectBigArrays.set(this.key, last, null);
        return last;
    }

    @Override
    public boolean remove(Object k) {
        long h = k == null ? -9148929187392628276L : HashCommon.murmurHash3((long)System.identityHashCode(k) ^ this.mask);
        int displ = (int)(h & (long)this.segmentMask);
        int base = (int)((h & this.mask) >>> 27);
        while (this.used[base][displ]) {
            if (this.key[base][displ] == k) {
                --this.size;
                this.shiftKeys((long)base * 0x8000000L + (long)displ);
                return true;
            }
            base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
        }
        return false;
    }

    @Override
    public boolean contains(Object k) {
        long h = k == null ? -9148929187392628276L : HashCommon.murmurHash3((long)System.identityHashCode(k) ^ this.mask);
        int displ = (int)(h & (long)this.segmentMask);
        int base = (int)((h & this.mask) >>> 27);
        while (this.used[base][displ]) {
            if (this.key[base][displ] == k) {
                return true;
            }
            base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0L) {
            return;
        }
        this.size = 0L;
        BooleanBigArrays.fill(this.used, false);
        ObjectBigArrays.fill(this.key, null);
    }

    @Override
    public ObjectIterator<K> iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        long l = HashCommon.bigArraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(long n) {
        long l = HashCommon.bigArraySize(n, this.f);
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(long newN) {
        boolean[][] used = this.used;
        K[][] key = this.key;
        boolean[][] newUsed = BooleanBigArrays.newBigArray(newN);
        Object[][] newKey = ObjectBigArrays.newBigArray(newN);
        long mask = newN - 1L;
        int newSegmentMask = newKey[0].length - 1;
        int newBaseMask = newKey.length - 1;
        int base = 0;
        int displ = 0;
        long i = this.size;
        while (i-- != 0L) {
            while (!used[base][displ]) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            K k = key[base][displ];
            long h = k == null ? -9148929187392628276L : HashCommon.murmurHash3((long)System.identityHashCode(k) ^ mask);
            int d = (int)(h & (long)newSegmentMask);
            int b = (int)((h & mask) >>> 27);
            while (newUsed[b][d]) {
                b = b + ((d = d + 1 & newSegmentMask) == 0 ? 1 : 0) & newBaseMask;
            }
            newUsed[b][d] = true;
            newKey[b][d] = k;
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        this.n = newN;
        this.key = newKey;
        this.used = newUsed;
        this.initMasks();
        this.maxFill = HashCommon.maxFill(this.n, this.f);
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public ReferenceOpenHashBigSet<K> clone() {
        ReferenceOpenHashBigSet c;
        try {
            c = (ReferenceOpenHashBigSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = ObjectBigArrays.copy(this.key);
        c.used = BooleanBigArrays.copy(this.used);
        return c;
    }

    @Override
    public int hashCode() {
        boolean[][] used = this.used;
        K[][] key = this.key;
        int h = 0;
        int base = 0;
        int displ = 0;
        long j = this.size;
        while (j-- != 0L) {
            while (!used[base][displ]) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            if (this != key[base][displ]) {
                h += key[base][displ] == null ? 0 : System.identityHashCode(key[base][displ]);
            }
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator i = this.iterator();
        s.defaultWriteObject();
        long j = this.size;
        while (j-- != 0L) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.bigArraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = ObjectBigArrays.newBigArray(this.n);
        Object[][] key = this.key;
        this.used = BooleanBigArrays.newBigArray(this.n);
        boolean[][] used = this.used;
        this.initMasks();
        long i = this.size;
        while (i-- != 0L) {
            Object k = s.readObject();
            long h = k == null ? -9148929187392628276L : HashCommon.murmurHash3((long)System.identityHashCode(k) ^ this.mask);
            int base = (int)((h & this.mask) >>> 27);
            int displ = (int)(h & (long)this.segmentMask);
            while (used[base][displ]) {
                base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
            }
            used[base][displ] = true;
            key[base][displ] = k;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractObjectIterator<K> {
        int base;
        int displ;
        int lastBase;
        int lastDispl;
        long c;
        ReferenceArrayList<K> wrapped;

        private SetIterator() {
            this.c = ReferenceOpenHashBigSet.this.size;
            this.base = ReferenceOpenHashBigSet.this.key.length;
            this.lastBase = -1;
            boolean[][] used = ReferenceOpenHashBigSet.this.used;
            if (this.c != 0L) {
                do {
                    if (this.displ-- != 0) continue;
                    --this.base;
                    this.displ = (int)ReferenceOpenHashBigSet.this.mask;
                } while (!used[this.base][this.displ]);
            }
        }

        @Override
        public boolean hasNext() {
            return this.c != 0L;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.base < 0) {
                this.lastBase = --this.base;
                return this.wrapped.get(-this.base - 2);
            }
            this.lastBase = this.base;
            this.lastDispl = this.displ;
            Object retVal = ReferenceOpenHashBigSet.this.key[this.lastBase][this.lastDispl];
            if (this.c != 0L) {
                boolean[][] used = ReferenceOpenHashBigSet.this.used;
                do {
                    if (this.displ-- != 0) continue;
                    if (this.base-- == 0) break;
                    this.displ = (int)ReferenceOpenHashBigSet.this.mask;
                } while (!used[this.base][this.displ]);
            }
            return retVal;
        }

        protected final long shiftKeys(long pos) {
            long last;
            while (true) {
                last = pos;
                pos = last + 1L & ReferenceOpenHashBigSet.this.mask;
                while (BooleanBigArrays.get(ReferenceOpenHashBigSet.this.used, pos)) {
                    long slot = (ObjectBigArrays.get(ReferenceOpenHashBigSet.this.key, pos) == null ? -9148929187392628276L : HashCommon.murmurHash3((long)System.identityHashCode(ObjectBigArrays.get(ReferenceOpenHashBigSet.this.key, pos)) ^ ReferenceOpenHashBigSet.this.mask)) & ReferenceOpenHashBigSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1L & ReferenceOpenHashBigSet.this.mask;
                }
                if (!BooleanBigArrays.get(ReferenceOpenHashBigSet.this.used, pos)) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ReferenceArrayList();
                    }
                    this.wrapped.add(ObjectBigArrays.get(ReferenceOpenHashBigSet.this.key, pos));
                }
                ObjectBigArrays.set(ReferenceOpenHashBigSet.this.key, last, ObjectBigArrays.get(ReferenceOpenHashBigSet.this.key, pos));
            }
            BooleanBigArrays.set(ReferenceOpenHashBigSet.this.used, last, false);
            ObjectBigArrays.set(ReferenceOpenHashBigSet.this.key, last, null);
            return last;
        }

        @Override
        public void remove() {
            if (this.lastBase == -1) {
                throw new IllegalStateException();
            }
            if (this.base < -1) {
                ReferenceOpenHashBigSet.this.remove(this.wrapped.set(-this.base - 2, (Object)null));
                this.lastBase = -1;
                return;
            }
            --ReferenceOpenHashBigSet.this.size;
            if (this.shiftKeys((long)this.lastBase * 0x8000000L + (long)this.lastDispl) == (long)this.base * 0x8000000L + (long)this.displ && this.c > 0L) {
                ++this.c;
                this.next();
            }
            this.lastBase = -1;
        }
    }
}

