/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.util.Arrays;
import org.caffinitas.ohc.tables.AbstractDataOutput;
import org.caffinitas.ohc.tables.Murmur3;

final class KeyBuffer
extends AbstractDataOutput {
    private final byte[] array;
    private int p;
    private long hash;

    KeyBuffer(int size) {
        this.array = new byte[size];
    }

    byte[] array() {
        return this.array;
    }

    int size() {
        return this.array.length;
    }

    long hash() {
        return this.hash;
    }

    KeyBuffer finish() {
        long k2;
        long k1;
        int r;
        int o = 0;
        long h1 = 0L;
        long h2 = 0L;
        for (r = this.size(); r >= 16; r -= 16) {
            k1 = this.getLong(o);
            k2 = this.getLong(o += 8);
            o += 8;
            h1 ^= Murmur3.mixK1(k1);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            h2 ^= Murmur3.mixK2(k2);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        k1 = 0L;
        k2 = 0L;
        switch (r) {
            case 15: {
                k2 ^= Murmur3.toLong(this.array[o + 14]) << 48;
            }
            case 14: {
                k2 ^= Murmur3.toLong(this.array[o + 13]) << 40;
            }
            case 13: {
                k2 ^= Murmur3.toLong(this.array[o + 12]) << 32;
            }
            case 12: {
                k2 ^= Murmur3.toLong(this.array[o + 11]) << 24;
            }
            case 11: {
                k2 ^= Murmur3.toLong(this.array[o + 10]) << 16;
            }
            case 10: {
                k2 ^= Murmur3.toLong(this.array[o + 9]) << 8;
            }
            case 9: {
                k2 ^= Murmur3.toLong(this.array[o + 8]);
            }
            case 8: {
                k1 ^= this.getLong(o);
                break;
            }
            case 7: {
                k1 ^= Murmur3.toLong(this.array[o + 6]) << 48;
            }
            case 6: {
                k1 ^= Murmur3.toLong(this.array[o + 5]) << 40;
            }
            case 5: {
                k1 ^= Murmur3.toLong(this.array[o + 4]) << 32;
            }
            case 4: {
                k1 ^= Murmur3.toLong(this.array[o + 3]) << 24;
            }
            case 3: {
                k1 ^= Murmur3.toLong(this.array[o + 2]) << 16;
            }
            case 2: {
                k1 ^= Murmur3.toLong(this.array[o + 1]) << 8;
            }
            case 1: {
                k1 ^= Murmur3.toLong(this.array[o]);
                break;
            }
            default: {
                throw new AssertionError((Object)"Should never get here.");
            }
        }
        h1 ^= Murmur3.mixK1(k1);
        h2 ^= Murmur3.mixK2(k2);
        h1 ^= (long)this.size();
        h1 += (h2 ^= (long)this.size());
        h2 += h1;
        h1 = Murmur3.fmix64(h1);
        h2 = Murmur3.fmix64(h2);
        this.hash = h1 += h2;
        return this;
    }

    private long getLong(int o) {
        long l = Murmur3.toLong(this.array[o + 7]) << 56;
        l |= Murmur3.toLong(this.array[o + 6]) << 48;
        l |= Murmur3.toLong(this.array[o + 5]) << 40;
        l |= Murmur3.toLong(this.array[o + 4]) << 32;
        l |= Murmur3.toLong(this.array[o + 3]) << 24;
        l |= Murmur3.toLong(this.array[o + 2]) << 16;
        l |= Murmur3.toLong(this.array[o + 1]) << 8;
        return l |= Murmur3.toLong(this.array[o]);
    }

    @Override
    public void write(int b) {
        this.array[this.p++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.array, this.p, len);
        this.p += len;
    }

    @Override
    public void writeShort(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeInt(int v) {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeLong(long v) {
        this.write((int)(v >>> 56 & 0xFFL));
        this.write((int)(v >>> 48 & 0xFFL));
        this.write((int)(v >>> 40 & 0xFFL));
        this.write((int)(v >>> 32 & 0xFFL));
        this.write((int)(v >>> 24 & 0xFFL));
        this.write((int)(v >>> 16 & 0xFFL));
        this.write((int)(v >>> 8 & 0xFFL));
        this.write((int)(v & 0xFFL));
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBuffer keyBuffer = (KeyBuffer)o;
        return Arrays.equals(this.array, keyBuffer.array);
    }

    public int hashCode() {
        return (int)this.hash;
    }
}

