/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CompoundDenseCellName;
import org.apache.cassandra.db.composites.CompoundDenseCellNameType;
import org.apache.cassandra.db.composites.CompoundSparseCellName;
import org.apache.cassandra.db.composites.CompoundSparseCellNameType;
import org.apache.cassandra.db.composites.SimpleDenseCellName;
import org.apache.cassandra.db.composites.SimpleDenseCellNameType;
import org.apache.cassandra.db.composites.SimpleSparseCellName;
import org.apache.cassandra.db.composites.SimpleSparseCellNameType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;

public abstract class CellNames {
    private CellNames() {
    }

    public static CellNameType fromAbstractType(AbstractType<?> type, boolean isDense) {
        if (isDense) {
            if (type instanceof CompositeType) {
                return new CompoundDenseCellNameType(((CompositeType)type).types);
            }
            return new SimpleDenseCellNameType(type);
        }
        if (type instanceof CompositeType) {
            List<AbstractType<?>> types = ((CompositeType)type).types;
            if (types.get(types.size() - 1) instanceof ColumnToCollectionType) {
                assert (types.get(types.size() - 2) instanceof UTF8Type);
                return new CompoundSparseCellNameType.WithCollection(types.subList(0, types.size() - 2), (ColumnToCollectionType)types.get(types.size() - 1));
            }
            AbstractType<?> nameType = types.get(types.size() - 1);
            return new CompoundSparseCellNameType(types.subList(0, types.size() - 1), nameType);
        }
        return new SimpleSparseCellNameType(type);
    }

    public static CellName simpleDense(ByteBuffer bb) {
        assert (bb.hasRemaining());
        return new SimpleDenseCellName(bb);
    }

    public static CellName simpleSparse(ColumnIdentifier identifier) {
        return new SimpleSparseCellName(identifier);
    }

    public static CellName compositeDense(ByteBuffer ... bbs) {
        return new CompoundDenseCellName(bbs);
    }

    public static CellName compositeSparse(ByteBuffer[] bbs, ColumnIdentifier identifier, boolean isStatic) {
        return new CompoundSparseCellName(bbs, identifier, isStatic);
    }

    public static CellName compositeSparseWithCollection(ByteBuffer[] bbs, ByteBuffer collectionElement, ColumnIdentifier identifier, boolean isStatic) {
        return new CompoundSparseCellName.WithCollection(bbs, identifier, collectionElement, isStatic);
    }

    public static String getColumnsString(CellNameType type, Iterable<Cell> columns) {
        StringBuilder builder = new StringBuilder();
        for (Cell cell : columns) {
            builder.append(cell.getString(type)).append(",");
        }
        return builder.toString();
    }
}

