/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.InetAddressSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class InetAddressType
extends AbstractType<InetAddress> {
    public static final InetAddressType instance = new InetAddressType();

    InetAddressType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        InetAddress address;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            address = InetAddress.getByName(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make inetaddress from '%s'", source), e);
        }
        return this.decompose(address);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.INET;
    }

    @Override
    public TypeSerializer<InetAddress> getSerializer() {
        return InetAddressSerializer.instance;
    }

    @Override
    public boolean isByteOrderComparable() {
        return true;
    }
}

