/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class BufferedPoolingSegmentedFile
extends PoolingSegmentedFile {
    public BufferedPoolingSegmentedFile(String path, long length) {
        super(path, length);
    }

    @Override
    protected RandomAccessReader createReader(String path) {
        return RandomAccessReader.open(new File(path), this);
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path) {
            long length = new File(path).length();
            return new BufferedPoolingSegmentedFile(path, length);
        }

        @Override
        public SegmentedFile openEarly(String path) {
            return this.complete(path);
        }
    }
}

