/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.PropertyFileSnitch;
import org.apache.cassandra.locator.ReconnectableSnitchHelper;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ResourceWatcher;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipingPropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(GossipingPropertyFileSnitch.class);
    private PropertyFileSnitch psnitch;
    private volatile String myDC;
    private volatile String myRack;
    private volatile boolean preferLocal;
    private AtomicReference<ReconnectableSnitchHelper> snitchHelperReference = new AtomicReference();
    private volatile boolean gossipStarted;
    private Map<InetAddress, Map<String, String>> savedEndpoints;
    private static final String DEFAULT_DC = "UNKNOWN_DC";
    private static final String DEFAULT_RACK = "UNKNOWN_RACK";
    private static final int DEFAULT_REFRESH_PERIOD_IN_SECONDS = 60;

    public GossipingPropertyFileSnitch() throws ConfigurationException {
        this(60);
    }

    public GossipingPropertyFileSnitch(int refreshPeriodInSeconds) throws ConfigurationException {
        this.reloadConfiguration();
        try {
            this.psnitch = new PropertyFileSnitch();
            logger.info("Loaded {} for compatibility", (Object)"cassandra-topology.properties");
        }
        catch (ConfigurationException e) {
            logger.info("Unable to load {}; compatibility mode disabled", (Object)"cassandra-topology.properties");
        }
        try {
            FBUtilities.resourceToFile("cassandra-rackdc.properties");
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws ConfigurationException {
                    GossipingPropertyFileSnitch.this.reloadConfiguration();
                }
            };
            ResourceWatcher.watch("cassandra-rackdc.properties", runnable, refreshPeriodInSeconds * 1000);
        }
        catch (ConfigurationException ex) {
            logger.error("{} found, but does not look like a plain file. Will not watch it for changes", (Object)"cassandra-rackdc.properties");
        }
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.myDC;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.DC) == null) {
            if (this.psnitch == null) {
                if (this.savedEndpoints == null) {
                    this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
                }
                if (this.savedEndpoints.containsKey(endpoint)) {
                    return this.savedEndpoints.get(endpoint).get("data_center");
                }
                return DEFAULT_DC;
            }
            return this.psnitch.getDatacenter(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    @Override
    public String getRack(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.myRack;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.RACK) == null) {
            if (this.psnitch == null) {
                if (this.savedEndpoints == null) {
                    this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
                }
                if (this.savedEndpoints.containsKey(endpoint)) {
                    return this.savedEndpoints.get(endpoint).get("rack");
                }
                return DEFAULT_RACK;
            }
            return this.psnitch.getRack(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public void gossiperStarting() {
        super.gossiperStarting();
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_IP, StorageService.instance.valueFactory.internalIP(FBUtilities.getLocalAddress().getHostAddress()));
        this.reloadGossiperState();
        this.gossipStarted = true;
    }

    private void reloadConfiguration() throws ConfigurationException {
        SnitchProperties properties = new SnitchProperties();
        String newDc = properties.get("dc", null);
        String newRack = properties.get("rack", null);
        if (newDc == null || newRack == null) {
            throw new ConfigurationException("DC or rack not found in snitch properties, check your configuration in: cassandra-rackdc.properties");
        }
        newDc = newDc.trim();
        newRack = newRack.trim();
        boolean newPreferLocal = Boolean.parseBoolean(properties.get("prefer_local", "false"));
        if (!newDc.equals(this.myDC) || !newRack.equals(this.myRack) || this.preferLocal != newPreferLocal) {
            this.myDC = newDc;
            this.myRack = newRack;
            this.preferLocal = newPreferLocal;
            this.reloadGossiperState();
            if (StorageService.instance != null) {
                StorageService.instance.getTokenMetadata().invalidateCachedRings();
            }
            if (this.gossipStarted) {
                StorageService.instance.gossipSnitchInfo();
            }
        }
    }

    private void reloadGossiperState() {
        if (Gossiper.instance != null) {
            ReconnectableSnitchHelper pendingHelper = new ReconnectableSnitchHelper(this, this.myDC, this.preferLocal);
            Gossiper.instance.register(pendingHelper);
            pendingHelper = this.snitchHelperReference.getAndSet(pendingHelper);
            if (pendingHelper != null) {
                Gossiper.instance.unregister(pendingHelper);
            }
        }
    }
}

