/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiConverter;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.util.Patterns;

@Plugin(name="style", category="Converter")
@ConverterKeys(value={"style"})
public final class StyleConverter
extends LogEventPatternConverter
implements AnsiConverter {
    private final List<PatternFormatter> patternFormatters;
    private final boolean noAnsi;
    private final String style;
    private final String defaultStyle;

    public static StyleConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on style");
            return null;
        }
        if (options[1] == null) {
            LOGGER.error("No style attributes provided");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        String style = AnsiEscape.createSequence(options[1].split(Patterns.COMMA_SEPARATOR));
        boolean noConsoleNoAnsi = options.length > 2 && "noConsoleNoAnsi=true".equals(options[2]);
        boolean hideAnsi = noConsoleNoAnsi && System.console() == null;
        return new StyleConverter(formatters, style, hideAnsi);
    }

    private StyleConverter(List<PatternFormatter> patternFormatters, String style, boolean noAnsi) {
        super("style", "style");
        this.patternFormatters = patternFormatters;
        this.style = style;
        this.defaultStyle = AnsiEscape.getDefaultStyle();
        this.noAnsi = noAnsi;
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : this.patternFormatters) {
            formatter.format(event, buf);
        }
        if (buf.length() > 0) {
            if (this.noAnsi) {
                toAppendTo.append(buf.toString());
            } else {
                toAppendTo.append(this.style).append(buf.toString()).append(this.defaultStyle);
            }
        }
    }

    @Override
    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.patternFormatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[style=");
        sb.append(this.style);
        sb.append(", defaultStyle=");
        sb.append(this.defaultStyle);
        sb.append(", patternFormatters=");
        sb.append(this.patternFormatters);
        sb.append(", noAnsi=");
        sb.append(this.noAnsi);
        sb.append(']');
        return sb.toString();
    }
}

