/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.caffinitas.ohc.CacheSerializer;

public final class BenchmarkUtils {
    public static final CacheSerializer<byte[]> serializer = new CacheSerializer<byte[]>(){

        public void serialize(byte[] bytes, DataOutput stream) throws IOException {
            stream.writeInt(bytes.length);
            stream.write(bytes);
        }

        public byte[] deserialize(DataInput stream) throws IOException {
            byte[] bytes = new byte[stream.readInt()];
            stream.readFully(bytes);
            return bytes;
        }

        public int serializedSize(byte[] t) {
            return t.length + 4;
        }
    };
    public static final CacheSerializer<Long> longSerializer = new CacheSerializer<Long>(){

        public void serialize(Long val, DataOutput out) throws IOException {
            out.writeLong(val);
        }

        public Long deserialize(DataInput in) throws IOException {
            return in.readLong();
        }

        public int serializedSize(Long value) {
            return 8;
        }
    };

    public static class KeySerializer
    implements CacheSerializer<Long> {
        private final int keyLen;

        public KeySerializer(int keyLen) {
            this.keyLen = keyLen;
        }

        public void serialize(Long val, DataOutput out) throws IOException {
            out.writeLong(val);
            for (int i = 0; i < this.keyLen; ++i) {
                out.write(0);
            }
        }

        public Long deserialize(DataInput in) throws IOException {
            long v = in.readLong();
            for (int i = 0; i < this.keyLen; ++i) {
                in.readByte();
            }
            return v;
        }

        public int serializedSize(Long value) {
            return 8 + this.keyLen;
        }
    }
}

