/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark.distribution;

import org.caffinitas.ohc.benchmark.distribution.Distribution;

public class DistributionInverted
extends Distribution {
    final Distribution wrapped;
    final long min;
    final long max;

    public DistributionInverted(Distribution wrapped) {
        this.wrapped = wrapped;
        this.min = wrapped.minValue();
        this.max = wrapped.maxValue();
    }

    @Override
    public long next() {
        return this.max - (this.wrapped.next() - this.min);
    }

    @Override
    public double nextDouble() {
        return (double)this.max - (this.wrapped.nextDouble() - (double)this.min);
    }

    @Override
    public long inverseCumProb(double cumProb) {
        return this.max - (this.wrapped.inverseCumProb(cumProb) - this.min);
    }

    @Override
    public void setSeed(long seed) {
        this.wrapped.setSeed(seed);
    }

    public static Distribution invert(Distribution distribution) {
        if (distribution instanceof DistributionInverted) {
            return ((DistributionInverted)distribution).wrapped;
        }
        return new DistributionInverted(distribution);
    }
}

