/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark;

import java.util.concurrent.Future;
import org.caffinitas.ohc.benchmark.MergeableTimerSource;
import org.caffinitas.ohc.benchmark.ReadTask;
import org.caffinitas.ohc.benchmark.Shared;
import org.caffinitas.ohc.benchmark.Task;
import org.caffinitas.ohc.benchmark.WriteTask;
import org.caffinitas.ohc.benchmark.distribution.Distribution;
import org.caffinitas.ohc.benchmark.distribution.FasterRandom;

final class Driver
implements Runnable {
    final Distribution readKeyDist;
    final Distribution writeKeyDist;
    final Distribution valueSizeDist;
    final double readWriteRatio;
    final FasterRandom rnd;
    long endAt;
    Future<?> future;
    boolean stop;
    MergeableTimerSource[] timers = new MergeableTimerSource[]{new MergeableTimerSource(), new MergeableTimerSource()};

    Driver(Distribution readKeyDist, Distribution writeKeyDist, Distribution valueSizeDist, double readWriteRatio, long seed) {
        this.readKeyDist = readKeyDist;
        this.writeKeyDist = writeKeyDist;
        this.valueSizeDist = valueSizeDist;
        this.readWriteRatio = readWriteRatio;
        this.rnd = new FasterRandom();
        this.rnd.setSeed(seed);
    }

    @Override
    public void run() {
        try {
            long writeTrigger = (long)(this.readWriteRatio * 9.223372036854776E18);
            this.stop = false;
            while (System.currentTimeMillis() < this.endAt) {
                boolean read = this.rnd.nextLong() >>> 1 <= writeTrigger;
                Task task = read ? new ReadTask(this.readKeyDist.next()) : new WriteTask(this.writeKeyDist.next(), (int)this.valueSizeDist.next());
                this.timers[task.timer()].time(task);
                if (!Shared.fatal.get()) continue;
                System.err.println("Unhandled exception caught - exiting");
                this.stop = true;
                return;
            }
            this.stop = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Shared.fatal.set(true);
            this.stop = true;
        }
    }

    public void clearStats() {
        for (MergeableTimerSource timer : this.timers) {
            timer.clear();
        }
    }
}

