/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.caffinitas.ohc.benchmark.distribution.Distribution;

public class DistributionBoundApache
extends Distribution {
    final AbstractRealDistribution delegate;
    final long min;
    final long max;

    public DistributionBoundApache(AbstractRealDistribution delegate, long min, long max) {
        this.delegate = delegate;
        this.min = min;
        this.max = max;
    }

    @Override
    public long next() {
        return DistributionBoundApache.bound(this.min, this.max, this.delegate.sample());
    }

    @Override
    public double nextDouble() {
        return DistributionBoundApache.boundDouble(this.min, this.max, this.delegate.sample());
    }

    @Override
    public long inverseCumProb(double cumProb) {
        return DistributionBoundApache.bound(this.min, this.max, this.delegate.inverseCumulativeProbability(cumProb));
    }

    @Override
    public void setSeed(long seed) {
        this.delegate.reseedRandomGenerator(seed);
    }

    private static long bound(long min, long max, double val) {
        long r = (long)val;
        if (r >= min & r <= max) {
            return r;
        }
        if (r < min) {
            return min;
        }
        if (r > max) {
            return max;
        }
        throw new IllegalStateException();
    }

    private static double boundDouble(long min, long max, double r) {
        if (r >= (double)min & r <= (double)max) {
            return r;
        }
        if (r < (double)min) {
            return min;
        }
        if (r > (double)max) {
            return max;
        }
        throw new IllegalStateException();
    }
}

