/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark;

import java.nio.ByteBuffer;
import org.caffinitas.ohc.CacheSerializer;

public final class BenchmarkUtils {
    public static final CacheSerializer<byte[]> serializer = new CacheSerializer<byte[]>(){

        public void serialize(byte[] bytes, ByteBuffer buf) {
            buf.putInt(bytes.length);
            buf.put(bytes);
        }

        public byte[] deserialize(ByteBuffer buf) {
            byte[] bytes = new byte[buf.getInt()];
            buf.get(bytes);
            return bytes;
        }

        public int serializedSize(byte[] t) {
            return t.length + 4;
        }
    };
    public static final CacheSerializer<Long> longSerializer = new CacheSerializer<Long>(){

        public void serialize(Long val, ByteBuffer buf) {
            buf.putLong(val);
        }

        public Long deserialize(ByteBuffer buf) {
            return buf.getLong();
        }

        public int serializedSize(Long value) {
            return 8;
        }
    };

    public static class KeySerializer
    implements CacheSerializer<Long> {
        private final int keyLen;

        public KeySerializer(int keyLen) {
            this.keyLen = keyLen;
        }

        public void serialize(Long val, ByteBuffer buf) {
            buf.putLong(val);
            for (int i = 0; i < this.keyLen; ++i) {
                buf.put((byte)0);
            }
        }

        public Long deserialize(ByteBuffer buf) {
            long v = buf.getLong();
            for (int i = 0; i < this.keyLen; ++i) {
                buf.get();
            }
            return v;
        }

        public int serializedSize(Long value) {
            return 8 + this.keyLen;
        }
    }
}

