/*
 *      Copyright (C) 2014 Robert Stupp, Koeln, Germany, robert-stupp.de
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.caffinitas.ohc.linked;

import sun.misc.Unsafe;

abstract class UnsExt
{
    final Unsafe unsafe;

    UnsExt(Unsafe unsafe)
    {
        this.unsafe = unsafe;
    }

    abstract long getAndPutLong(long address, long offset, long value);

    abstract long getAndAddLong(long address, long offset, long value);

    abstract int getAndPutInt(long address, long offset, int value);

    abstract int getAndAddInt(long address, long offset, int value);

    abstract long crc32(long address, long offset, long len);
}
