/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledExecutorService;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.linked.OHCacheImpl;

public class OHCacheBuilder<K, V> {
    private int segmentCount;
    private int hashTableSize = 8192;
    private int bucketLength = 8;
    private long capacity;
    private CacheSerializer<K> keySerializer;
    private CacheSerializer<V> valueSerializer;
    private float loadFactor = 0.75f;
    private long maxEntrySize;
    private Class<? extends OHCache> type = OHCacheImpl.class;
    private ScheduledExecutorService executorService;
    private boolean throwOOME;
    public static final String SYSTEM_PROPERTY_PREFIX = "org.caffinitas.ohc.";

    private OHCacheBuilder() {
        int cpus = Runtime.getRuntime().availableProcessors();
        this.segmentCount = OHCacheBuilder.roundUpToPowerOf2(cpus * 2, 0x40000000);
        this.capacity = Math.min(cpus * 16, 64) * 1024 * 1024;
        this.segmentCount = OHCacheBuilder.fromSystemProperties("segmentCount", this.segmentCount);
        this.hashTableSize = OHCacheBuilder.fromSystemProperties("hashTableSize", this.hashTableSize);
        this.bucketLength = OHCacheBuilder.fromSystemProperties("bucketLength", this.bucketLength);
        this.capacity = OHCacheBuilder.fromSystemProperties("capacity", this.capacity);
        this.loadFactor = OHCacheBuilder.fromSystemProperties("loadFactor", this.loadFactor);
        this.maxEntrySize = OHCacheBuilder.fromSystemProperties("maxEntrySize", this.maxEntrySize);
        this.throwOOME = OHCacheBuilder.fromSystemProperties("throwOOME", this.throwOOME);
        String t = OHCacheBuilder.fromSystemProperties("type", null);
        if (t != null) {
            try {
                this.type = Class.forName(t);
            }
            catch (ClassNotFoundException x) {
                try {
                    this.type = Class.forName(SYSTEM_PROPERTY_PREFIX + t + ".OHCacheImpl");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static float fromSystemProperties(String name, float defaultValue) {
        try {
            return Float.parseFloat(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Float.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static long fromSystemProperties(String name, long defaultValue) {
        try {
            return Long.parseLong(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Long.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static int fromSystemProperties(String name, int defaultValue) {
        try {
            return Integer.parseInt(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Integer.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static boolean fromSystemProperties(String name, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Boolean.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static String fromSystemProperties(String name, String defaultValue) {
        return System.getProperty(SYSTEM_PROPERTY_PREFIX + name, defaultValue);
    }

    static int roundUpToPowerOf2(int number, int max) {
        return number >= max ? max : (number > 1 ? Integer.highestOneBit(number - 1 << 1) : 1);
    }

    public static <K, V> OHCacheBuilder<K, V> newBuilder() {
        return new OHCacheBuilder<K, V>();
    }

    public OHCache<K, V> build() {
        try {
            return this.type.getDeclaredConstructor(OHCacheBuilder.class).newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends OHCache> getType() {
        return this.type;
    }

    public OHCacheBuilder<K, V> type(Class<? extends OHCache> type) {
        this.type = type;
        return this;
    }

    public int getHashTableSize() {
        return this.hashTableSize;
    }

    public OHCacheBuilder<K, V> hashTableSize(int hashTableSize) {
        this.hashTableSize = hashTableSize;
        return this;
    }

    public int getBucketLength() {
        return this.bucketLength;
    }

    public OHCacheBuilder<K, V> bucketLength(int bucketLength) {
        this.bucketLength = bucketLength;
        return this;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public OHCacheBuilder<K, V> capacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public CacheSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OHCacheBuilder<K, V> keySerializer(CacheSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public CacheSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public OHCacheBuilder<K, V> valueSerializer(CacheSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public OHCacheBuilder<K, V> segmentCount(int segmentCount) {
        this.segmentCount = segmentCount;
        return this;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public OHCacheBuilder<K, V> loadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
        return this;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public OHCacheBuilder<K, V> maxEntrySize(long maxEntrySize) {
        this.maxEntrySize = maxEntrySize;
        return this;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public OHCacheBuilder<K, V> executorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public boolean isThrowOOME() {
        return this.throwOOME;
    }

    public OHCacheBuilder<K, V> throwOOME(boolean throwOOME) {
        this.throwOOME = throwOOME;
        return this;
    }
}

