/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.alloc;

import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.InvocationMapper;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.caffinitas.ohc.alloc.IAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEMallocAllocator
implements IAllocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JEMallocAllocator.class);
    private final JEMLibrary library;

    public JEMallocAllocator() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("invocation-mapper", new InvocationMapper(){

            public InvocationHandler getInvocationHandler(NativeLibrary lib, Method m) {
                final Function f = lib.getFunction(JEMallocAllocator.jemallocExportedName(m.getName()));
                if ("malloc".equals(m.getName())) {
                    return new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) {
                            return f.invokeLong(args);
                        }
                    };
                }
                if ("free".equals(m.getName())) {
                    return new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) {
                            f.invoke(args);
                            return null;
                        }
                    };
                }
                return null;
            }
        });
        options.put("function-mapper", new FunctionMapper(){

            public String getFunctionName(NativeLibrary library, Method method) {
                return JEMallocAllocator.jemallocExportedName(method.getName());
            }
        });
        this.library = (JEMLibrary)Native.loadLibrary((String)"jemalloc", JEMLibrary.class, options);
        if (this.mallctlBool("opt.zero")) {
            LOGGER.warn("jemalloc is has opt.fill enabled - this leads to performance penalties");
        }
        if (this.mallctlBool("opt.redzone")) {
            LOGGER.warn("jemalloc is has opt.redzone enabled - this leads to performance penalties");
        }
        if (this.mallctlBool("opt.junk")) {
            LOGGER.warn("jemalloc is has opt.junk enabled - this leads to performance penalties");
        }
        if (this.mallctlBool("config.debug")) {
            LOGGER.warn("jemalloc is compiled with debug code - this leads to performance penalties");
        }
        if (this.mallctlBool("config.fill")) {
            LOGGER.warn("jemalloc is compiled with fill option - this leads to performance penalties");
        }
    }

    static String jemallocExportedName(String name) {
        String osName;
        if ("mallctl".equals(name) && (osName = System.getProperty("os.name").toLowerCase()).contains("os x")) {
            return "je_mallctl";
        }
        return name;
    }

    @Override
    public long getTotalAllocated() {
        long allocated = this.mallctlSizeT("stats.allocated");
        long hugeAllocated = this.mallctlSizeT("stats.huge.allocated");
        return allocated + hugeAllocated;
    }

    private boolean mallctlBool(String name) {
        Memory oldp = new Memory(1L);
        Memory oldlenp = new Memory((long)NativeLong.SIZE);
        oldlenp.setNativeLong(0L, new NativeLong(oldp.size()));
        int r = this.library.mallctl(name, (Pointer)oldp, (Pointer)oldlenp, null, 0L);
        return r == 0 && oldp.getByte(0L) != 0;
    }

    private long mallctlSizeT(String name) {
        Memory oldp = new Memory((long)NativeLong.SIZE);
        Memory oldlenp = new Memory((long)NativeLong.SIZE);
        oldlenp.setNativeLong(0L, new NativeLong(oldp.size()));
        int r = this.library.mallctl(name, (Pointer)oldp, (Pointer)oldlenp, null, 0L);
        return r != 0 ? 0L : oldp.getNativeLong(0L).longValue();
    }

    @Override
    public long allocate(long size) {
        return this.library.malloc(size);
    }

    @Override
    public void free(long peer) {
        this.library.free(peer);
    }

    public static interface JEMLibrary
    extends Library {
        public long malloc(long var1);

        public void free(long var1);

        public int mallctl(String var1, Pointer var2, Pointer var3, Pointer var4, long var5);
    }
}

