/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

final class Util {
    static final int POINTER_LEN = 8;
    static final long ENTRY_OFF_REFCOUNT = 0L;
    static final long ENTRY_OFF_SENTINEL = 4L;
    static final long ENTRY_OFF_LRU_INDEX = 8L;
    static final long ENTRY_OFF_HASH = 16L;
    static final long ENTRY_OFF_VALUE_LENGTH = 24L;
    static final long ENTRY_OFF_KEY_LENGTH = 32L;
    static final long ENTRY_OFF_DATA = 40L;
    static final long BUCKET_ENTRY_LEN = 16L;
    static final long BUCKET_OFF_HASH = 8L;
    static final int HEADER_COMPRESSED = 1330135875;
    static final int HEADER_COMPRESSED_WRONG = 1128482895;
    static final int HEADER_ENTRIES = 1330135877;
    static final int HEADER_ENTRIES_WRONG = 1162037327;
    static final int HEADER_KEYS = 1330135883;
    static final int HEADER_KEYS_WRONG = 1262700623;

    Util() {
    }

    static long roundUpTo8(long val) {
        long rem = val & 7L;
        if (rem != 0L) {
            val += 8L - rem;
        }
        return val;
    }

    static long allocLen(long keyLen, long valueLen) {
        return 40L + Util.roundUpTo8(keyLen) + valueLen;
    }

    static void writeFully(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            channel.write(buffer);
        }
    }

    static boolean readFully(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            int rd = channel.read(buffer);
            if (rd != -1) continue;
            return false;
        }
        return true;
    }

    static int bitNum(long val) {
        int bit = 0;
        while (val != 0L) {
            val >>>= 1;
            ++bit;
        }
        return bit;
    }

    static long roundUpToPowerOf2(long number, long max) {
        return number >= max ? max : (number > 1L ? Long.highestOneBit(number - 1L << 1) : 1L);
    }

    static ByteBuffer allocateByteBuffer(int size) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }

    static ByteBuffer wrap(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }
}

