/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.jmh;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.caffinitas.ohc.CacheSerializer;

public final class Utils {
    public static final CacheSerializer<byte[]> byteArraySerializer = new CacheSerializer<byte[]>(){

        public void serialize(byte[] bytes, DataOutput out) throws IOException {
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        public byte[] deserialize(DataInput in) throws IOException {
            byte[] arr = new byte[in.readInt()];
            in.readFully(arr);
            return arr;
        }

        public int serializedSize(byte[] bytes) {
            return 4 + bytes.length;
        }
    };
    public static final CacheSerializer<Integer> intSerializer = new CacheSerializer<Integer>(){

        public void serialize(Integer integer, DataOutput out) throws IOException {
            out.writeInt(integer);
        }

        public Integer deserialize(DataInput in) throws IOException {
            return in.readInt();
        }

        public int serializedSize(Integer integer) {
            return 4;
        }
    };
}

