/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.jmh;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.caffinitas.ohc.alloc.IAllocator;
import org.caffinitas.ohc.alloc.JNANativeAllocator;
import org.caffinitas.ohc.alloc.UnsafeAllocator;
import org.caffinitas.ohc.jmh.FasterRandom;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@State(value=Scope.Benchmark)
@Warmup(iterations=2)
@Measurement(iterations=3)
@Threads(value=4)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=1, jvmArgsAppend={"-Xmx512M"})
public class AllocatorBenchmark {
    @Param(value={"128", "8192"})
    private int size = 128;
    @Param(value={"Unsafe", "JNA"})
    private String allocatorType = "JNA";
    private IAllocator allocator;

    @Setup
    public void createAllocator() {
        switch (this.allocatorType) {
            case "Unsafe": {
                this.allocator = new UnsafeAllocator();
                break;
            }
            case "JNA": {
                this.allocator = new JNANativeAllocator();
            }
        }
    }

    @TearDown
    public void tearDown(Allocations allocations) throws IOException {
        allocations.freeAll(this.allocator);
    }

    @Benchmark
    @Threads(value=1)
    public void allocateSingleThreaded(Rand rand, Allocations state) {
        state.allocate(this.allocator, rand, this.size);
    }

    @Benchmark
    @Threads(value=4)
    public void allocateMultiThreaded(Rand rand, Allocations state) {
        state.allocate(this.allocator, rand, this.size);
    }

    @State(value=Scope.Benchmark)
    public static class Allocations {
        final AtomicLong[] adrs = new AtomicLong[1024];

        public Allocations() {
            for (int i = 0; i < this.adrs.length; ++i) {
                this.adrs[i] = new AtomicLong();
            }
        }

        void allocate(IAllocator allocator, Rand rand, int size) {
            long a;
            int idx = rand.nextInt(this.adrs.length);
            AtomicLong adr = this.adrs[idx];
            while ((a = adr.get()) != 0L) {
                if (!adr.compareAndSet(a, 0L)) continue;
                allocator.free(a);
                break;
            }
            if (!adr.compareAndSet(0L, a = allocator.allocate((long)size))) {
                allocator.free(a);
            }
        }

        void freeAll(IAllocator allocator) {
            for (AtomicLong al : this.adrs) {
                long adr = al.get();
                if (adr == 0L) continue;
                allocator.free(adr);
            }
        }
    }

    @State(value=Scope.Thread)
    public static class Rand
    extends FasterRandom {
    }
}

