/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.jmh;

import java.util.Random;
import org.apache.commons.math3.random.RandomGenerator;

public class FasterRandom
implements RandomGenerator {
    final Random random = new Random();
    private long seed;
    private int reseed;

    public void setSeed(int seed) {
        this.setSeed((long)seed);
    }

    public void setSeed(int[] ints) {
        if (ints.length > 1) {
            this.setSeed((long)ints[0] << 32 | (long)ints[1]);
        } else {
            this.setSeed(ints[0]);
        }
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.rollover();
    }

    private void rollover() {
        this.reseed = 0;
        this.random.setSeed(this.seed);
        this.seed = this.random.nextLong();
    }

    public void nextBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            long next = this.nextLong();
            while (i < bytes.length) {
                bytes[i++] = (byte)(next & 0xFFL);
                next >>>= 8;
            }
        }
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int i) {
        return Math.abs((int)this.nextLong() % i);
    }

    public long nextLong() {
        if (++this.reseed == 32) {
            this.rollover();
        }
        long seed = this.seed;
        seed ^= seed >> 12;
        seed ^= seed << 25;
        seed ^= seed >> 27;
        this.seed = seed;
        return seed * 2685821657736338717L;
    }

    public boolean nextBoolean() {
        return ((int)this.nextLong() & 1) == 1;
    }

    public float nextFloat() {
        return Float.intBitsToFloat((int)this.nextLong());
    }

    public double nextDouble() {
        return Double.longBitsToDouble(this.nextLong());
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }
}

