/*
 * Copyright 2014 - 2019 Cafienne B.V.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.cafienne.consentgroup.actorapi.event;

import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.ConsentGroupMessage;

import java.util.Set;

/**
 * ConsentGroupEvents are generated by the {@link ConsentGroupActor}.
 */
public interface ConsentGroupEvent extends ModelEvent, ConsentGroupMessage {
    String TAG = "cafienne:consentgroup";

    Set<String> tags = Set.of(ModelEvent.TAG, ConsentGroupEvent.TAG);

    @Override
    default Set<String> tags() {
        return tags;
    }
}
