/*
 * Copyright 2014 - 2019 Cafienne B.V.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.cafienne.consentgroup.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

import java.io.IOException;

/**
 * ConsentGroupEvents are generated by the {@link ConsentGroupActor}.
 */
public abstract class ConsentGroupMemberEvent extends ConsentGroupBaseEvent {
    public final String userId;
    public final ConsentGroupMember member;

    protected ConsentGroupMemberEvent(ConsentGroupActor group, ConsentGroupMember member) {
        super(group);
        this.userId = member.userId();
        this.member = member;
    }

    protected ConsentGroupMemberEvent(ValueMap json) {
        super(json);
        this.userId = json.readString(Fields.userId);
        this.member = json.readObject(Fields.member, ConsentGroupMember::deserialize);
    }

    @Override
    public String getDescription() {
        return super.getDescription() +" - " + userId;
    }

    public void writeConsentGroupMemberEvent(JsonGenerator generator) throws IOException {
        super.writeConsentGroupEvent(generator);
        writeField(generator, Fields.userId, userId);
        // TODO???: "flat map" the member fields, to make the event's json little more readable
        writeField(generator, Fields.member, member);
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        writeConsentGroupMemberEvent(generator);
    }
}
