/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel;

import akka.actor.Cancellable;
import java.util.concurrent.TimeUnit;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.Reception;
import org.cafienne.actormodel.Responder;
import org.cafienne.actormodel.StagingArea;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.CommandException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.actormodel.response.ActorChokedFailure;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.actormodel.response.SecurityFailure;
import org.cafienne.infrastructure.Cafienne;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

class BackOffice {
    private final ModelActor actor;
    private final Reception reception;
    private Cancellable selfCleaner = null;

    BackOffice(ModelActor modelActor, Reception reception) {
        this.actor = modelActor;
        this.reception = reception;
    }

    void handleVisitor(IncomingActorMessage incomingActorMessage) {
        this.clearSelfCleaner();
        StagingArea stagingArea = this.reception.warehouse.prepareNextShipment(incomingActorMessage);
        if (incomingActorMessage.isCommand()) {
            ModelCommand modelCommand = incomingActorMessage.asCommand();
            this.actor.addDebugInfo(() -> "---------- User " + modelCommand.getUser().id() + " in " + this.actor + " starts command " + modelCommand.getCommandDescription(), modelCommand.toJson());
            try {
                modelCommand.validateCommand(this.actor);
                stagingArea.setResponse(modelCommand.processCommand(this.actor));
            }
            catch (AuthorizationException authorizationException) {
                stagingArea.reportFailure(authorizationException, new SecurityFailure(modelCommand, authorizationException), "");
            }
            catch (InvalidCommandException invalidCommandException) {
                stagingArea.reportFailure(modelCommand, invalidCommandException, "===== Command was invalid ======");
            }
            catch (CommandException commandException) {
                stagingArea.reportFailure(modelCommand, commandException, "---------- User " + modelCommand.getUser().id() + " in " + this.actor + " failed to complete command " + modelCommand + "\nwith exception");
            }
            catch (Throwable throwable) {
                stagingArea.reportFailure(throwable, new ActorChokedFailure(modelCommand, throwable), "---------- Engine choked during validation of command with type " + modelCommand.getClass().getSimpleName() + " from user " + modelCommand.getUser().id() + " in " + this.actor + "\nwith exception");
            }
        } else if (incomingActorMessage instanceof ModelResponse) {
            this.handleResponse((ModelResponse)incomingActorMessage);
        }
        stagingArea.store();
        this.enableSelfCleaner();
    }

    private void handleResponse(ModelResponse modelResponse) {
        Responder responder = this.actor.getResponseListener(modelResponse.getMessageId());
        if (responder == null) {
            this.actor.getLogger().warn(this.actor + " received a response to a message that was not sent through it. Sender: " + this.actor.sender() + ", response: " + modelResponse);
        } else if (modelResponse instanceof CommandFailure) {
            responder.left.handleFailure((CommandFailure)modelResponse);
        } else {
            responder.right.handleResponse(modelResponse);
        }
    }

    private void clearSelfCleaner() {
        if (this.selfCleaner != null) {
            this.selfCleaner.cancel();
            this.selfCleaner = null;
        }
    }

    private void enableSelfCleaner() {
        if (this.actor.hasAutoShutdown()) {
            long l = Cafienne.config().actor().idlePeriod();
            FiniteDuration finiteDuration = Duration.create((long)l, (TimeUnit)TimeUnit.MILLISECONDS);
            this.selfCleaner = this.actor.getScheduler().schedule(finiteDuration, this.actor::takeABreak);
        }
    }
}

