/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel;

import akka.actor.AbstractActor;
import akka.actor.PoisonPill;
import akka.persistence.AbstractPersistentActor;
import akka.persistence.SnapshotOffer;
import akka.persistence.SnapshotProtocol;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.cafienne.actormodel.CaseScheduler;
import org.cafienne.actormodel.Reception;
import org.cafienne.actormodel.Responder;
import org.cafienne.actormodel.Warehouse;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.exception.CommandException;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.CommandFailureListener;
import org.cafienne.actormodel.response.CommandResponseListener;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.instance.debug.DebugInfoAppender;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.infrastructure.CafienneVersion;
import org.cafienne.infrastructure.enginedeveloper.EngineDeveloperConsole;
import org.cafienne.processtask.actorapi.command.ProcessCommand;
import org.cafienne.system.CaseSystem;
import org.cafienne.system.health.HealthMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelActor
extends AbstractPersistentActor {
    private static final Logger logger = LoggerFactory.getLogger(ModelActor.class);
    private String tenant;
    private final String id;
    private final Reception reception = new Reception(this);
    private final Warehouse warehouse;
    private UserIdentity currentUser;
    private boolean debugMode;
    private final Map<String, Responder> responseListeners;
    private final CaseScheduler scheduler;
    private Instant lastModified;
    private Instant transactionTimestamp;
    private CafienneVersion engineVersion;
    public final CaseSystem caseSystem;

    protected ModelActor(CaseSystem caseSystem) {
        this.warehouse = this.reception.warehouse;
        this.debugMode = Cafienne.config().actor().debugEnabled();
        this.responseListeners = new HashMap<String, Responder>();
        this.caseSystem = caseSystem;
        this.id = this.self().path().name();
        this.scheduler = new CaseScheduler(this);
    }

    protected abstract boolean supportsCommand(Object var1);

    protected abstract boolean supportsEvent(ModelEvent var1);

    protected boolean hasAutoShutdown() {
        return true;
    }

    public CafienneVersion getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(CafienneVersion cafienneVersion) {
        this.engineVersion = cafienneVersion;
    }

    public String getParentActorId() {
        return "";
    }

    public String getRootActorId() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public String persistenceId() {
        return this.id;
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public boolean debugMode() {
        return this.debugMode;
    }

    public UserIdentity getCurrentUser() {
        return this.currentUser;
    }

    public final void setCurrentUser(UserIdentity userIdentity) {
        this.currentUser = userIdentity;
    }

    public CaseScheduler getScheduler() {
        return this.scheduler;
    }

    public AbstractActor.Receive createReceiveRecover() {
        return this.receiveBuilder().match(Object.class, this.reception::handleRecovery).build();
    }

    public final AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Object.class, this.reception::handleMessage).build();
    }

    protected void handleSnapshot(SnapshotOffer snapshotOffer) {
    }

    protected void handleSnapshotProtocolMessage(SnapshotProtocol.Response response) {
    }

    protected void recoveryCompleted() {
        this.getLogger().info("Recovery of " + ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getId() + " completed");
    }

    void takeABreak() {
        this.getLogger().debug("Removing actor " + ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getId() + " from memory, as it has been idle for " + Cafienne.config().actor().idlePeriod() / 1000L + " seconds");
        this.self().tell((Object)PoisonPill.getInstance(), this.self());
    }

    protected void handleBootstrapMessage(BootstrapMessage bootstrapMessage) {
        this.tenant = bootstrapMessage.tenant();
    }

    public <E extends ModelEvent> E addEvent(E e) {
        this.warehouse.storeEvent(e);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Responder getResponseListener(String string) {
        Map<String, Responder> map = this.responseListeners;
        synchronized (map) {
            return this.responseListeners.remove(string);
        }
    }

    public void askCase(CaseCommand caseCommand, CommandFailureListener commandFailureListener, CommandResponseListener ... commandResponseListenerArray) {
        this.askModel(caseCommand, commandFailureListener, commandResponseListenerArray);
    }

    public void askProcess(ProcessCommand processCommand, CommandFailureListener commandFailureListener, CommandResponseListener ... commandResponseListenerArray) {
        this.askModel(processCommand, commandFailureListener, commandResponseListenerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void askModel(ModelCommand modelCommand, CommandFailureListener commandFailureListener, CommandResponseListener ... commandResponseListenerArray) {
        if (this.recoveryRunning()) {
            return;
        }
        Map<String, Responder> map = this.responseListeners;
        synchronized (map) {
            this.responseListeners.put(modelCommand.getMessageId(), new Responder(commandFailureListener, commandResponseListenerArray));
        }
        this.caseSystem.gateway().inform(modelCommand, this.self());
    }

    public final String getTenant() {
        return this.tenant;
    }

    public void reply(ModelResponse modelResponse) {
        this.resetTransactionTimestamp();
        if (modelResponse == null) {
            return;
        }
        if (!(modelResponse instanceof CommandFailure)) {
            this.reception.unlock();
        }
        if (this.getLogger().isDebugEnabled() || EngineDeveloperConsole.enabled()) {
            String string = "Sending response of type " + modelResponse.getClass().getSimpleName() + " from " + this;
            if (modelResponse instanceof CommandFailure) {
                string = string + ": " + modelResponse;
            }
            this.getLogger().debug(string);
            EngineDeveloperConsole.debugIndentedConsoleLogging(string);
        }
        modelResponse.setLastModified(this.getLastModified());
        this.sender().tell((Object)modelResponse, this.self());
    }

    public void failedWithInvalidState(Object object, Throwable throwable) {
        this.getScheduler().clearSchedules();
        if (throwable instanceof CommandException) {
            this.getLogger().error("Restarting " + this + ". Handling msg of type " + object.getClass().getName() + " resulted in invalid state.");
            this.getLogger().error("  Cause: " + throwable.getClass().getSimpleName() + " - " + throwable.getMessage());
        } else {
            this.getLogger().error("Encountered failure in handling msg of type " + object.getClass().getName() + "; restarting " + this, throwable);
        }
        this.supervisorStrategy().restartChild(this.self(), throwable, true);
    }

    private void handlePersistFailure(Throwable throwable, Object object, long l) {
        this.getLogger().error("Failure in " + ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getId() + " during persistence of event " + l + " of type " + object.getClass().getName() + ". Stopping instance.", throwable);
        HealthMonitor.writeJournal().hasFailed(throwable);
        this.warehouse.handlePersistFailure(throwable, object, l);
        this.context().stop(this.self());
    }

    public void onPersistFailure(Throwable throwable, Object object, long l) {
        this.handlePersistFailure(throwable, object, l);
    }

    public void onPersistRejected(Throwable throwable, Object object, long l) {
        this.handlePersistFailure(throwable, object, l);
    }

    public void addDebugInfo(DebugInfoAppender debugInfoAppender, Object ... objectArray) {
        this.addDebugInfo(this.getLogger(), debugInfoAppender, objectArray);
    }

    public void addDebugInfo(Logger logger, DebugInfoAppender debugInfoAppender, Object ... objectArray) {
        this.warehouse.addDebugInfo(logger, debugInfoAppender, objectArray);
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public Instant getTransactionTimestamp() {
        if (this.transactionTimestamp == null) {
            this.transactionTimestamp = Instant.now();
        }
        return this.transactionTimestamp;
    }

    public void resetTransactionTimestamp() {
        this.transactionTimestamp = null;
    }

    public void setLastModified(Instant instant) {
        this.lastModified = instant;
    }

    protected Logger getLogger() {
        return logger;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.self().path().name() + "]";
    }

    protected void completeTransaction(IncomingActorMessage incomingActorMessage) {
    }
}

