/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.exception;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import org.cafienne.infrastructure.serialization.CafienneSerializable;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public class SerializedException
implements CafienneSerializable {
    private final String className;
    private final String message;
    private SerializedException cause;

    public SerializedException(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        if (throwable.getCause() != null) {
            this.cause = new SerializedException(throwable.getCause());
        }
    }

    public SerializedException(ValueMap valueMap) {
        this.className = valueMap.readString(Fields.className, new String[0]);
        this.message = valueMap.readString(Fields.message, new String[0]);
        ValueMap valueMap2 = valueMap.with(Fields.cause);
        if (!((Map)valueMap2.getValue()).isEmpty()) {
            this.cause = new SerializedException(valueMap2);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getClassName() {
        return this.className;
    }

    public <T extends Throwable> Class<T> getExceptionClass() {
        try {
            return Class.forName(this.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("The internal exception class with name " + this.className + " cannot be found in the classpath", classNotFoundException);
        }
    }

    public SerializedException getCause() {
        return this.cause;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeField(jsonGenerator, Fields.className, this.className);
        this.writeField(jsonGenerator, Fields.message, this.message);
        this.writeField(jsonGenerator, Fields.cause, this.cause);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.className + ": " + this.message);
        if (this.cause != null) {
            stringBuilder.append("\n\t" + this.cause);
        }
        return stringBuilder.toString();
    }
}

