/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.identity;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.actorapi.event.deprecated.DeprecatedTenantUserEvent;
import org.cafienne.tenant.actorapi.event.deprecated.OwnerAdded;
import org.cafienne.tenant.actorapi.event.deprecated.OwnerRemoved;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserCreated;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserDisabled;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserEnabled;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserRoleAdded;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserRoleRemoved;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserUpdated;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TenantUser$
implements LazyLogging,
Serializable {
    public static final TenantUser$ MODULE$ = new TenantUser$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        TenantUser$ tenantUser$ = this;
        synchronized (tenantUser$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public Set<String> $lessinit$greater$default$3() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public String $lessinit$greater$default$5() {
        return "";
    }

    public String $lessinit$greater$default$6() {
        return "";
    }

    public boolean $lessinit$greater$default$7() {
        return true;
    }

    public TenantUser deserialize(ValueMap json) {
        String id = json.readString(Fields.userId, new String[0]);
        String name = json.readString(Fields.name, "");
        String email = json.readString(Fields.email, "");
        String tenant = json.readString(Fields.tenant, new String[0]);
        boolean isOwner = Predef$.MODULE$.Boolean2boolean(json.readBoolean(Fields.isOwner, new Boolean[0]));
        boolean enabled = Predef$.MODULE$.Boolean2boolean(json.readBoolean(Fields.enabled, new Boolean[0]));
        Set roles = Predef$.MODULE$.wrapRefArray((Object[])json.readStringList(Fields.roles)).toSet();
        return new TenantUser(id, tenant, (Set<String>)roles, isOwner, name, email, enabled);
    }

    public void handleDeprecatedEvent(Map<String, TenantUser> users, DeprecatedTenantUserEvent event) {
        block20: {
            TenantUser tenantUser;
            String userId = event.userId;
            DeprecatedTenantUserEvent deprecatedTenantUserEvent = event;
            if (deprecatedTenantUserEvent instanceof TenantUserCreated) {
                TenantUserCreated tenantUserCreated = (TenantUserCreated)deprecatedTenantUserEvent;
                String x$1 = tenantUserCreated.userId;
                String x$2 = tenantUserCreated.tenant;
                Set x$3 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                String x$4 = tenantUserCreated.name;
                String x$5 = tenantUserCreated.email;
                boolean x$6 = false;
                boolean x$7 = true;
                tenantUser = new TenantUser(x$1, x$2, (Set<String>)x$3, false, x$4, x$5, true);
            } else {
                TenantUser tenantUser2;
                TenantUser user = users.get(event.userId);
                if (user == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Ignoring event of type " + this.getClass().getName() + ", because user with id " + userId + " does not exist in tenant " + event.tenant);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    tenantUser2 = null;
                } else {
                    TenantUser tenantUser3;
                    DeprecatedTenantUserEvent deprecatedTenantUserEvent2 = event;
                    if (deprecatedTenantUserEvent2 instanceof TenantUserUpdated) {
                        TenantUserUpdated tenantUserUpdated = (TenantUserUpdated)deprecatedTenantUserEvent2;
                        String x$8 = tenantUserUpdated.name;
                        String x$9 = tenantUserUpdated.email;
                        String x$10 = user.copy$default$1();
                        String x$11 = user.copy$default$2();
                        Set<String> x$12 = user.copy$default$3();
                        boolean x$13 = user.copy$default$4();
                        boolean x$14 = user.copy$default$7();
                        tenantUser3 = user.copy(x$10, x$11, x$12, x$13, x$8, x$9, x$14);
                    } else if (deprecatedTenantUserEvent2 instanceof TenantUserRoleAdded) {
                        TenantUserRoleAdded tenantUserRoleAdded = (TenantUserRoleAdded)deprecatedTenantUserEvent2;
                        Set x$15 = (Set)user.roles().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tenantUserRoleAdded.role})));
                        String x$16 = user.copy$default$1();
                        String x$17 = user.copy$default$2();
                        boolean x$18 = user.copy$default$4();
                        String x$19 = user.copy$default$5();
                        String x$20 = user.copy$default$6();
                        boolean x$21 = user.copy$default$7();
                        tenantUser3 = user.copy(x$16, x$17, (Set<String>)x$15, x$18, x$19, x$20, x$21);
                    } else if (deprecatedTenantUserEvent2 instanceof TenantUserRoleRemoved) {
                        TenantUserRoleRemoved tenantUserRoleRemoved = (TenantUserRoleRemoved)deprecatedTenantUserEvent2;
                        Set x$22 = (Set)user.roles().$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tenantUserRoleRemoved.role})));
                        String x$23 = user.copy$default$1();
                        String x$24 = user.copy$default$2();
                        boolean x$25 = user.copy$default$4();
                        String x$26 = user.copy$default$5();
                        String x$27 = user.copy$default$6();
                        boolean x$28 = user.copy$default$7();
                        tenantUser3 = user.copy(x$23, x$24, (Set<String>)x$22, x$25, x$26, x$27, x$28);
                    } else if (deprecatedTenantUserEvent2 instanceof OwnerAdded) {
                        boolean x$29 = true;
                        String x$30 = user.copy$default$1();
                        String x$31 = user.copy$default$2();
                        Set<String> x$32 = user.copy$default$3();
                        String x$33 = user.copy$default$5();
                        String x$34 = user.copy$default$6();
                        boolean x$35 = user.copy$default$7();
                        tenantUser3 = user.copy(x$30, x$31, x$32, true, x$33, x$34, x$35);
                    } else if (deprecatedTenantUserEvent2 instanceof OwnerRemoved) {
                        boolean x$36 = false;
                        String x$37 = user.copy$default$1();
                        String x$38 = user.copy$default$2();
                        Set<String> x$39 = user.copy$default$3();
                        String x$40 = user.copy$default$5();
                        String x$41 = user.copy$default$6();
                        boolean x$42 = user.copy$default$7();
                        tenantUser3 = user.copy(x$37, x$38, x$39, false, x$40, x$41, x$42);
                    } else if (deprecatedTenantUserEvent2 instanceof TenantUserDisabled) {
                        boolean x$43 = false;
                        String x$44 = user.copy$default$1();
                        String x$45 = user.copy$default$2();
                        Set<String> x$46 = user.copy$default$3();
                        boolean x$47 = user.copy$default$4();
                        String x$48 = user.copy$default$5();
                        String x$49 = user.copy$default$6();
                        tenantUser3 = user.copy(x$44, x$45, x$46, x$47, x$48, x$49, false);
                    } else if (deprecatedTenantUserEvent2 instanceof TenantUserEnabled) {
                        boolean x$50 = true;
                        String x$51 = user.copy$default$1();
                        String x$52 = user.copy$default$2();
                        Set<String> x$53 = user.copy$default$3();
                        boolean x$54 = user.copy$default$4();
                        String x$55 = user.copy$default$5();
                        String x$56 = user.copy$default$6();
                        tenantUser3 = user.copy(x$51, x$52, x$53, x$54, x$55, x$56, true);
                    } else {
                        tenantUser3 = null;
                    }
                    tenantUser2 = tenantUser3;
                }
                tenantUser = tenantUser2;
            }
            TenantUser user = tenantUser;
            if (user == null) break block20;
            users.put(userId, user);
        }
    }

    public TenantUser apply(String id, String tenant, Set<String> roles, boolean isOwner, String name, String email, boolean enabled) {
        return new TenantUser(id, tenant, roles, isOwner, name, email, enabled);
    }

    public Set<String> apply$default$3() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public boolean apply$default$4() {
        return false;
    }

    public String apply$default$5() {
        return "";
    }

    public String apply$default$6() {
        return "";
    }

    public boolean apply$default$7() {
        return true;
    }

    public Option<Tuple7<String, String, Set<String>, Object, String, String, Object>> unapply(TenantUser x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.id(), (Object)x$0.tenant(), x$0.roles(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isOwner()), (Object)x$0.name(), (Object)x$0.email(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.enabled())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TenantUser$.class);
    }

    private TenantUser$() {
    }
}

