/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.response;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.actormodel.response.ActorLastModified;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class BaseModelResponse
implements ModelResponse {
    private final String messageId;
    private final String actorId;
    private Instant lastModified;
    private final UserIdentity user;
    private final String commandType;

    protected BaseModelResponse(ModelCommand modelCommand) {
        this.messageId = modelCommand.getMessageId();
        this.actorId = modelCommand.actorId();
        this.lastModified = modelCommand.getActor() != null ? modelCommand.getActor().getLastModified() : null;
        this.user = modelCommand.getUser();
        this.commandType = modelCommand.getClass().getName();
    }

    protected BaseModelResponse(ValueMap valueMap) {
        this.messageId = valueMap.readString(Fields.messageId, new String[0]);
        this.actorId = valueMap.readString(Fields.actorId, new String[0]);
        this.lastModified = valueMap.readInstant(Fields.lastModified);
        this.user = valueMap.readObject(Fields.user, UserIdentity::deserialize);
        this.commandType = valueMap.readString(Fields.commandType, new String[0]);
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public String getActorId() {
        return this.actorId;
    }

    public String getCommandType() {
        return this.commandType;
    }

    @Override
    public void setLastModified(Instant instant) {
        this.lastModified = instant;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    @Override
    public ActorLastModified lastModifiedContent() {
        return new ActorLastModified(this.actorId, this.getLastModified());
    }

    @Override
    public UserIdentity getUser() {
        return this.user;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeField(jsonGenerator, Fields.messageId, this.getMessageId());
        this.writeField(jsonGenerator, Fields.actorId, this.actorId);
        this.writeField(jsonGenerator, Fields.commandType, this.commandType);
        this.writeField(jsonGenerator, Fields.lastModified, this.getLastModified());
        this.writeField(jsonGenerator, Fields.user, this.user);
    }

    public String toString() {
        return this.asString();
    }
}

