/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.team;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamCommand;
import org.cafienne.cmmn.definition.team.CaseTeamDefinition;
import org.cafienne.cmmn.instance.team.CaseTeamError;
import org.cafienne.cmmn.instance.team.Team;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class SetCaseTeam
extends CaseTeamCommand {
    private final CaseTeam caseTeam;

    public SetCaseTeam(CaseUserIdentity caseUserIdentity, String string, CaseTeam caseTeam) {
        super(caseUserIdentity, string);
        this.caseTeam = caseTeam;
    }

    public SetCaseTeam(ValueMap valueMap) {
        super(valueMap);
        this.caseTeam = CaseTeam.deserialize(valueMap.with(Fields.team));
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, Fields.team, this.caseTeam);
    }

    @Override
    public void validate(Team team) {
        if (this.caseTeam.isEmpty()) {
            throw new CaseTeamError("The new case team cannot be empty");
        }
        if (this.caseTeam.owners().isEmpty()) {
            throw new CaseTeamError("The new case team must have owners");
        }
        this.caseTeam.validate((CaseTeamDefinition)team.getDefinition());
    }

    @Override
    protected void process(Team team) {
        team.replace(this.caseTeam);
    }
}

