/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.team.setmember;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamCommand;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamMember;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamMemberDeserializer;
import org.cafienne.cmmn.definition.team.CaseTeamDefinition;
import org.cafienne.cmmn.instance.team.CaseTeamError;
import org.cafienne.cmmn.instance.team.Team;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.ValueMap;

abstract class SetCaseTeamMemberCommand<M extends CaseTeamMember>
extends CaseTeamCommand {
    protected final M newMember;

    protected SetCaseTeamMemberCommand(CaseUserIdentity caseUserIdentity, String string, M m) {
        super(caseUserIdentity, string);
        this.newMember = m;
    }

    protected SetCaseTeamMemberCommand(ValueMap valueMap, CaseTeamMemberDeserializer<M> caseTeamMemberDeserializer) {
        super(valueMap);
        this.newMember = caseTeamMemberDeserializer.readMember(valueMap.with(Fields.member));
    }

    @Override
    public void validate(Team team) {
        if (!this.newMember.isOwner()) {
            this.validateNotLastOwner(team);
        }
        this.newMember.validateRolesExist((CaseTeamDefinition)team.getDefinition());
    }

    protected void validateNotLastOwner(Team team) {
        CaseTeamMember caseTeamMember = this.newMember.currentMember(team);
        if (caseTeamMember != null && caseTeamMember.isOwner() && team.getOwners().size() == 1) {
            throw new CaseTeamError("Cannot remove the last case owner");
        }
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, Fields.member, (CafienneJson)this.newMember);
    }
}

