/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.cmmn.actorapi.event.definition.CaseDefinitionEvent;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.infrastructure.CafienneVersion;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class CaseDefinitionApplied
extends CaseDefinitionEvent
implements BootstrapMessage {
    public final CafienneVersion engineVersion;
    private final String parentCaseId;
    private final String rootCaseId;
    public final Instant createdOn;
    public final String createdBy;

    public CaseDefinitionApplied(Case case_, String string, String string2, CaseDefinition caseDefinition) {
        super(case_, caseDefinition);
        this.createdOn = case_.getTransactionTimestamp();
        this.createdBy = case_.getCurrentUser().id();
        this.rootCaseId = string;
        this.parentCaseId = string2;
        this.engineVersion = Cafienne.version();
    }

    public CaseDefinitionApplied(ValueMap valueMap) {
        super(valueMap);
        this.createdOn = valueMap.readInstant(Fields.createdOn);
        this.createdBy = valueMap.readString(Fields.createdBy, new String[0]);
        this.rootCaseId = valueMap.readString(Fields.rootActorId, new String[0]);
        this.parentCaseId = valueMap.readString(Fields.parentActorId, new String[0]);
        this.engineVersion = valueMap.readObject(Fields.engineVersion, CafienneVersion::new);
    }

    public String getRootCaseId() {
        return this.rootCaseId;
    }

    public String getParentCaseId() {
        return this.parentCaseId;
    }

    @Override
    public String toString() {
        return "Case definition " + this.getCaseName();
    }

    @Override
    public CaseDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void updateState(Case case_) {
        case_.updateState(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseDefinitionEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.createdOn, this.createdOn);
        this.writeField(jsonGenerator, Fields.createdBy, this.createdBy);
        this.writeField(jsonGenerator, Fields.rootActorId, this.rootCaseId);
        this.writeField(jsonGenerator, Fields.parentActorId, this.parentCaseId);
        this.writeField(jsonGenerator, Fields.engineVersion, this.engineVersion.json());
    }
}

