/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.file;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.CaseBaseEvent;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.InvalidPathException;
import org.cafienne.cmmn.instance.casefile.Path;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CaseFileEvent
extends CaseBaseEvent {
    protected static final Logger logger = LoggerFactory.getLogger(CaseFileEvent.class);
    public final Path path;
    protected transient CaseFileItem caseFileItem;

    protected CaseFileEvent(CaseFileItemCollection<?> caseFileItemCollection) {
        super(caseFileItemCollection.getCaseInstance());
        this.path = caseFileItemCollection.getPath();
    }

    protected CaseFileEvent(ValueMap valueMap) {
        super(valueMap);
        this.path = valueMap.readPath(Fields.path);
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public Path getPath() {
        return this.path;
    }

    public int getIndex() {
        return this.path.getIndex();
    }

    @Override
    public void updateState(Case case_) {
        try {
            this.caseFileItem = (CaseFileItem)this.path.resolve(case_);
            this.updateState(this.caseFileItem);
        }
        catch (InvalidPathException invalidPathException) {
            logger.error("Could not recover path '" + this.path + "' on case instance?!", (Throwable)invalidPathException);
        }
    }

    @Override
    protected abstract void updateState(CaseFileItem var1);

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "['" + this.path + "']";
    }

    public void writeCaseFileEvent(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.path, this.path);
    }
}

